/**
　 * <p>Title: RasterLayerShell.java</p>
　 * <p>Description: </p>
　 * <p>Copyright: Copyright (c) 2021</p>
　 * <p>Company: northpool</p>
　 * @author chy
　 * @date 2021年12月22日
　 * @version 1.0
*/
package com.northpool.service.config.raster_service.layer;

import java.util.Map;
import java.util.stream.Collectors;

import com.northpool.service.client.Client;
import com.northpool.service.config.raster_service.dataset.RasterDataSetBean;
import com.northpool.spatial.Constants.LAYER_TYPE;

/**
 * @author chy
 *
 */
public class RasterLayerShell implements IRasterLayer {

    protected RasterLayerBean layer;
    
    protected Client client;
    
    protected Map<String, RasterDataSetBean> dataSetHashMap;
    
    protected Map<Integer, IRasterLayerLevel> layerLevelMap;
    
    public RasterLayerShell(Client client, RasterLayerBean layer, Map<String, RasterDataSetBean> map) {
        this.client = client;
        this.layer = layer;
        this.dataSetHashMap = map;
        this.layerLevelMap = this.createLayerLevelMap(layer.getLevelMap());
    }
    
    private Map<Integer, IRasterLayerLevel> createLayerLevelMap(Map<Integer, RasterLayerLevelBean> levelMap) {
        return levelMap.entrySet().stream().map( entry -> {
            RasterLayerLevelBean layerLevel = entry.getValue();
            RasterLayerLevelShell layerLevelShell;
            try {
                layerLevelShell = new RasterLayerLevelShell( this.client, layerLevel, this.dataSetHashMap);
            } catch (Exception e) {
                throw new RuntimeException(e);
            }
            return layerLevelShell;
        }).collect(Collectors.toMap(RasterLayerLevelShell::getLevel, layerLevelShell->layerLevelShell));
    }

    @Override
    public String getId() {
        return this.layer.getId();
    }

    @Override
    public Integer getBeginLevel() {
        return this.layer.getBeginLevel();
    }

    @Override
    public Integer getEndLevel() {
        return this.layer.getEndLevel();
    }

    @Override
    public Map<Integer, IRasterLayerLevel> getLevelMap() {
        return this.layerLevelMap;
    }

    @Override
    public RasterLayerBean getBean() {
        return this.layer;
    }

    @Override
    public LAYER_TYPE getLayerType() {
        return this.layer.getLayerType();
    }

}
