package com.northpool.service.config.texture;

import com.alibaba.fastjson.JSON;
import com.northpool.service.config.Constants;
import com.northpool.service.config.IDocumentAble;
import org.bson.Document;

public class TextureBean implements IDocumentAble {

    protected String id;

    protected String name;

    protected String content;

    protected Integer width;

    protected Integer height;

    protected Long contentLength;

    protected Constants.TEXTURE_TYPE type;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Constants.TEXTURE_TYPE getType() {
        return type;
    }

    public void setType(Constants.TEXTURE_TYPE type) {
        this.type = type;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public Integer getWidth() {
        return width;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public Integer getHeight() {
        return height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public Long getContentLength() {
        return contentLength;
    }

    public void setContentLength(Long contentLength) {
        this.contentLength = contentLength;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toJson(){
        return JSON.toJSONString(this);
    }

    @Override
    public Document toDocument() {
        return Document.parse(this.toJson());
    }
}
