package com.northpool.service.dao.style;

import com.northpool.service.client.Client;
import com.northpool.service.config.style.IStyleService;
import com.northpool.service.config.style.StyleBean;
import com.northpool.service.config.style.StyleShell;
import com.northpool.service.dao.AbstractIgniteDao;
import com.northpool.service.manager.style.StyleManager;
import com.northpool.structure.queryhashtable.QueryHashTableHeap;
import org.apache.ignite.Ignite;

public class StyleIgniteDao extends AbstractIgniteDao<StyleBean, IStyleService> {

    public StyleIgniteDao(String idFieldName, QueryHashTableHeap<String, IStyleService> table, Client client, String managerRoot, Boolean readOnly, Ignite ignite, StyleManager manager) {
        super(idFieldName, table, client, managerRoot, readOnly, ignite);
        this.manager = manager;
    }

   /* @Override
    protected IgniteCache<String, StyleBean> createCache() throws Exception {
        CacheConfiguration<String, StyleBean> cacheCfg = new CacheConfiguration<String, StyleBean>();
        cacheCfg.setName(this.managerRoot);
        cacheCfg.setCacheMode(CacheMode.REPLICATED);
        cacheCfg.setSqlSchema("PUBLIC");
        cacheCfg.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        QueryEntity queryEntity = new QueryEntity(String.class, StyleBean.class)
                .addQueryField("uuid", String.class.getName(), null)
                .addQueryField("name", String.class.getName(), null)
                .addQueryField("ownServer", String.class.getName(), null)
                .addQueryField("styleJson", String.class.getName(), null)
                .addQueryField("textureLabel", String[].class.getName(), null)
                .addQueryField("textureLayer", String[].class.getName(), null)
                .addQueryField("extFonts", String[].class.getName(), null)
                .addQueryField("styleLayerJs", byte[].class.getName(), null)
                .addQueryField("styleLabelJs", byte[].class.getName(), null)
                .addQueryField("styleAvoidjs", byte[].class.getName(), null)
                .addQueryField("queryLayer", byte[].class.getName(), null)
                .addQueryField("queryLabel", byte[].class.getName(), null)
                .addQueryField("mapboxStyle", byte[].class.getName(), null)
                .addQueryField("version", String.class.getName(), null)
                .addQueryField("isTmp", Boolean.class.getName(), null)
                .addQueryField("xmin", Double.class.getName(), null)
                .addQueryField("ymin", Double.class.getName(), null)
                .addQueryField("xmax", Double.class.getName(), null)
                .addQueryField("ymax", Double.class.getName(), null);



        queryEntity.setIndexes(Arrays.asList(new QueryIndex(this.idFieldName)));

        cacheCfg.setQueryEntities(Arrays.asList(queryEntity));

        return ignite.createCache(cacheCfg);
    }*/

/*    public List<IStyleService> findAll() throws Exception{
        Iterator<Cache.Entry<String, StyleBean>> iterator = this.cache.iterator();
        List<IStyleService> list = new ArrayList<>(this.cache.size());
        while(iterator.hasNext()){
            Cache.Entry<String, StyleBean> entry = iterator.next();
            StyleBean styleBean = entry.getValue();
            if (styleBean.getUuid() == null) {
                styleBean.se
            }
            list.add(this.getShell(entry.getValue()));
        }
        return list;
    }*/

    @Override
    protected IStyleService getShell(StyleBean bean) {
        return new StyleShell(bean);
    }

}
