package com.northpool.service.manager.abstractclass;

import com.northpool.bean.Idable;
import com.northpool.bean.Jsonable;
import com.northpool.bean.JsonableBuilder;
import com.northpool.commons.event.EventContainer;
import com.northpool.commons.event.Listener;
import com.northpool.exception.Message;
import com.northpool.exception.UException;
import com.northpool.resources.command.QueryFilter;
import com.northpool.resources.datatable.dao.IScroll;
import com.northpool.resources.exception.IdFieldValueEmptyException;
import com.northpool.service.client.Client;
import com.northpool.service.config.IBeanBuilder;
import com.northpool.service.config.IDocumentAble;
import com.northpool.service.config.IVersionAble;
import com.northpool.service.dao.IMetaDataDao;
import com.northpool.service.manager.IMetaDataManager;
import com.northpool.structure.queryhashtable.QueryHashTableHeap;
import org.apache.curator.framework.recipes.cache.PathChildrenCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Date;
import java.util.List;

public abstract class AbstractManager<T extends Jsonable & Idable<String> & IDocumentAble, Builder extends JsonableBuilder<T> & DocumentableBuilder<T> & IBeanBuilder> implements IMetaDataManager<T> {
	Logger logger = LoggerFactory.getLogger(AbstractManager.class);

	protected QueryHashTableHeap<String,T> table;
	protected String idFieldName = "id";//默认主键字段为id
	protected Client client;
	protected Boolean readOnly = false;
	protected String managerRoot;	
	protected PathChildrenCache HolderCache;
	protected static final String INFO_FIELD = "data";
	protected Builder beanBuilder;
	protected Boolean isReady = false;
	protected EventContainer<Listener> eventContainer = new EventContainer<Listener>();

	protected IMetaDataDao<T> metaDataDao;

	/*protected AbstractZkDao<T,Builder> zkDao;

	protected IMongoDao<T> mongoDao;*/

	public AbstractManager(Builder beanBuilder, String managerRoot){
		this.managerRoot = managerRoot;
		this.beanBuilder = beanBuilder;
	}
	
	/*public AbstractManager(String idFieldName,Builder beanBuilder, String managerRoot){
		this.idFieldName = idFieldName;
		this.managerRoot = managerRoot;
		this.beanBuilder = beanBuilder;

	}*/
	

	public void init() throws Exception {
/*		if (this.metaDataDao == null){
			throw new Message("元数据访问初始化异常");
		}*/
		this.beanBuilder.setClient(client);
		this.table = new QueryHashTableHeap<String, T>(this.idFieldName);

		this.metaDataDao = this.getMetaDataDao();
		//List<T> list = this.mongoDao.find(new BsonDocument());
		List<T> list = this.metaDataDao.findAll();
		for (T t : list) {
			this.saveBeanToHashTable(t);
		}
		//table.insertMany(list);

/*		if (this.client.getZoo() != null){
			this.isReady = true;
		}else {
			throw new RuntimeException("zk没有准备好");
		}*/
		
	}
	
	protected abstract IMetaDataDao<T> getMetaDataDao() throws Exception;

	protected void saveBeanToHashTable(T bean){
		if (this.table == null){
			return;
		}
		this.table.insert(bean);
		
	}
	
	protected void removeBeanToHashTable(String pk){
		if (this.table == null){
			return;
		}
		this.table.remove(pk);
	}
	
	protected void updateBeanToHashTable(T bean){
		if (this.table == null){
			return;
		}
		this.table.update(bean);
		
	}
	

	
	public Boolean exists(String id) throws Exception {
		if (this.table.get(id) != null){//内存里有则认为有，内存没有再请求zk
			return true;
		}else {
			return this.metaDataDao.exists(id);
		}
		/*if (this.mongoDao != null){
			return this.mongoDao.exists(id);
		}else if (this.zkDao != null){
			boolean isExists = this.zkDao.exists(id);
			return isExists;
		}
		return false;*/

	}
	

	protected void isReady() throws ZKException{

	/*	if(!this.isReady){
			throw new ZKException("zk初始化没有成功");
		}*/
	}
	
	/**
	 * 处理add事件
	 * @param t
	 * @throws ExistsIdException
	 * @throws ZKException
	 * @throws IdFieldValueEmptyException
	 */
	protected void doAdd(T t) throws Exception{
		this.isReady();
		String id = t.getId();
		if(id == null){
			throw new IdFieldValueEmptyException(this.idFieldName, t);
		}
		if (this.exists(id)){
			throw new ExistsIdException(id);
		}

		if (t instanceof IVersionAble){
			String version = ((IVersionAble) t).getVersion();
			if (version == null){
				((IVersionAble) t).setVersion(new Date().getTime() + "");
			}
		}

		this.saveBeanToHashTable(t);

		try {
			this.metaDataDao.insert(t);
		}catch (Exception e){
			UException.printStackTrace(e);
			this.removeBeanToHashTable(id);
			throw e;
		}
	/*
		if (this.mongoDao != null){
			this.mongoDao.insertOne(t);
		}

		if (this.zkDao != null){
			try {
				this.zkDao.insert(t);
			} catch (Exception e) {
				// TODO Auto-generated catch block
				UException.printStackTrace(e);
				this.removeBeanToHashTable(id);
				this.mongoDao.deleteone(id);
				throw new ZKException(e);
			}
		}*/
		eventContainer.syncFireEvent(EventMessage.EVENT_TYPE.register.name(), id,t);
	}


	/**
	 * 响应更新事件
	 * @param t
	 * @throws ZKException
	 */
	protected void doUpdate(T t) throws   Exception  {
		this.isReady();
		String id = t.getId();
		if(id == null){
			throw new IdFieldValueEmptyException(this.idFieldName, t);
		}
		if (!this.exists(id)){
			throw new NotFoundException(id);
		}

		if (t instanceof IVersionAble){//有版本号的，每次更新修改版本号
			IVersionAble versionAble = (IVersionAble) t;
			versionAble.setVersion(new Date().getTime() + "");
		}

		this.updateBeanToHashTable(t);

		try {
			this.metaDataDao.update(t);
		} catch (Exception e) {
			UException.printStackTrace(e);
			throw e;
		}

		/*if (this.mongoDao != null){
			this.mongoDao.updateOne(id, t);
		}

		if (this.zkDao != null){
			this.zkDao.update(t);
		}*/

		eventContainer.syncFireEvent(EventMessage.EVENT_TYPE.update.name(), id,t);
	}

	protected void doRemove(String id) throws Exception{
		this.isReady();
		if (!this.exists(id)){
			throw new NotFoundException(id);
		}

		this.removeBeanToHashTable(id);

		try {
			this.metaDataDao.delete(id);
		} catch (Exception e) {
			UException.printStackTrace(e);
			throw e;
		}

		/*if (this.mongoDao != null){
			this.mongoDao.deleteone(id);
		}

		if (this.zkDao != null){
			try {
				this.zkDao.delete(id);
			} catch (Exception e) {
				// TODO Auto-generated catch block
				UException.printStackTrace(e);
				throw new ZKException(e);
			}
		}*/

		eventContainer.syncFireEvent(EventMessage.EVENT_TYPE.unRegister.name(), id, this.get(id));
	}

	@SuppressWarnings("unchecked")
	public void on(EventMessage.EVENT_TYPE type,EventMessage<T> e){
		eventContainer.on(type.name(), (Object ...parameter) -> {
			T t;
			if (parameter[1] == null){
				t = null;
			}else{
				t = (T)parameter[1];
			}
			e.fire((String)parameter[0],t);
		});
	}
	
	public List<T> list(QueryFilter queryFilter) {
		if (this.table != null){
			return this.table.query(queryFilter);
		}else {
			return null;
		}
	}

	public List<T> findAll() {
		if (this.table != null){
			return this.table.query(new QueryFilter());
		}else {
			return null;
		}
	}
	
	
	public T findOne(QueryFilter queryFilter){
		IScroll<T> scroll = this.table.scroll(queryFilter);
		if(scroll.hasNext()){
			return scroll.next();
		}else{
			return null;
		}
	}
	
	
	
	public IScroll<T> scroll(QueryFilter queryFilter){
		if (this.table != null){
			return this.table.scroll(queryFilter);
		}else {
			return null;
		}
	}
	
	public T get(String id) {
		// TODO Auto-generated method stub
		T t = this.table.get(id);
		if (t == null){//缓存里没有，再去库里找一次
			try {
				t = this.metaDataDao.findOne(id);
			} catch (Exception e) {
				throw new Message(this.managerRoot + ": id为 " + id + "的数据拉取失败");
			}
			if (t != null){
				try {
					this.table.insert(t);
				}catch (Exception e){
					this.logger.warn("缓存中已经存在id为：" + id + "的数据，忽略本次插入");
				}
			}
		}
		return t;
		/*if (this.table != null){
			return this.table.get(id);
		}else if (this.mongoDao != null){
=======
	    if (this.zkDao != null) {
            T result = this.table.get(id);
            if (result != null) {
                return result;
            }
            
            try {
                return this.zkDao.getFromZK(id);
            } catch (Exception e) {
                UException.printStackTrace(e);
                return null;
            }
        } else if (this.mongoDao != null){
>>>>>>> a7f43264c81e0cb5216ff25b35bf4583b6001da3
			T bean = this.mongoDao.findone(id);
            return bean;
        }else {
			return null;
        }*/
    }

    public String getJSON(String id) {
		T bean = this.get(id);
		if (bean != null){
			return bean.toJson();
		}
		return null;
	}

	public void setClient(Client client) {
		this.client = client;
	}

	public void setReadOnly(boolean readOnly){
		this.readOnly = readOnly;
	}

}

