/**
 * 
 */
package com.northpool.service.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

/**
 * 
 * Copyright © 2017 Geoway. All rights reserved.
 * 
 * @Title: GzipUtils.java
 * @Prject: press-core
 * @Package: com.geoway.press.core.utils
 * @Description:
 * @author: lz
 * @date: 2017年11月26日 上午10:42:13
 * @version: V1.0
 */
public class GzipUtils {
	public static String uncompressed(byte[] b) throws IOException {
		GZIPInputStream gin = new GZIPInputStream(new ByteArrayInputStream(b));
		ByteArrayOutputStream bout = new ByteArrayOutputStream();
		byte[] buf = new byte[1024];
		int len = -1;
		while ((len = gin.read(buf)) != -1) {
			bout.write(buf, 0, len);
		}
		return new String(bout.toByteArray(), "UTF-8");
	}

	public static byte[] uncompressedContent(byte[] b) throws IOException {
		GZIPInputStream gin = new GZIPInputStream(new ByteArrayInputStream(b));
		ByteArrayOutputStream bout = new ByteArrayOutputStream();
		byte[] buf = new byte[1024];
		int len = -1;
		while ((len = gin.read(buf)) != -1) {
			bout.write(buf, 0, len);
		}
		return bout.toByteArray();
	}

	public static byte[] compress(String str, String encoding) throws IOException {
		if (str == null || str.length() == 0) {
			return null;
		}
		ByteArrayOutputStream out = new ByteArrayOutputStream();
		GZIPOutputStream gzip = new GZIPOutputStream(out);
		gzip.write(str.getBytes(encoding));
		gzip.close();
		return out.toByteArray();
	}
	public static byte[] compress(byte[] content) throws IOException {
		if (content == null) {
			return null;
		}
		ByteArrayOutputStream out = new ByteArrayOutputStream();
		GZIPOutputStream gzip = new GZIPOutputStream(out);
		gzip.write(content);
		gzip.close();
		return out.toByteArray();
	}
}
