package com.northpool.service.xmlloader;

import com.northpool.commons.event.EventContainer;
import com.northpool.commons.event.Listener;
import com.northpool.service.client.Client;
import com.northpool.service.config.vector_service.IVectorService;
import com.northpool.service.config.vector_service.VectorServiceBean;
import com.northpool.service.config.vector_service.VectorServiceShell;
import com.northpool.service.exception.ReservedWordsConflictException;
import com.northpool.service.xmlloader.vectorservice.VectorServiceLoader;

import java.io.InputStream;
import java.util.Arrays;


public class RegisterXmlToServer {
	protected Client client;
	
	public RegisterXmlToServer(Client client){
		this.client = client;
	}
	
	protected EventContainer<Listener> eventContainer = new EventContainer<Listener>();
	
	public IVectorService register(InputStream inXMl) throws Exception{
		VectorServiceLoader xml = new VectorServiceLoader(client);
		VectorServiceBean service = xml.load(inXMl);
		IVectorService VectorServiceShell = new VectorServiceShell(this.client,service);
		client.getVectorServiceManager().register(VectorServiceShell);
		
		
		
		return VectorServiceShell;
	}

    public IVectorService register(InputStream inXMl, String[] reservedWords)
			throws Exception {
        VectorServiceLoader xml = new VectorServiceLoader(client);
        VectorServiceBean service = xml.load(inXMl);
        String serviceId = service.getId();
        if (Arrays.asList(reservedWords).contains(serviceId)) {
            throw new ReservedWordsConflictException("服务ID " + serviceId + " 与系统保留字冲突");
        }
        
        IVectorService VectorServiceShell = new VectorServiceShell(this.client,service);
        client.getVectorServiceManager().register(VectorServiceShell);
        
        return VectorServiceShell;
    }
    
	public void on(RegisterXmlToServerMessage.EVENT_TYPE type,RegisterXmlToServerMessage e){
		eventContainer.on(type.name(), (Object ...parameter) -> {
			e.fire(parameter[0]);
		});
	}
}
