package com.northpool.devtool.AbnormalCheck;

import com.northpool.devtool.AbnormalCheck.abstractclass.AbstractCheck;
import com.northpool.devtool.utils.NetUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;

/**
 * @author Bai Chenguang
 * @Date: 2022/06/23/ 下午 8:03
 * @Description
 */
public class MapserverCheck extends AbstractCheck implements IAbnormalCheck {
    private static Logger logger = LoggerFactory.getLogger(MapserverCheck.class);

    Integer TIME_OUT = 3000;
    String url = "127.0.0.1:80";

    static MapserverCheck inst;

    public MapserverCheck(String url) {
        this.url = url;
    }

    public static MapserverCheck getInst(String url) {
        if (inst == null) {
            inst = new MapserverCheck(url);
        } else {
            inst.url = url;
        }
        return inst;
    }

    @Override
    public void check() {
        try {
            URI uri = new URI(url);
            boolean flag = NetUtils.testIpAndPort(uri.getHost(), uri.getPort(), TIME_OUT);
            if (!flag) {
                logger.error("Mapserver 地址无法访问：{}", url);
                logger.error("1.请排查Mapserver服务是否正常启动");
                logger.error("2.检查网络ip/端口是否开放");
                super.shutdown();
            }
        } catch (URISyntaxException e) {
            logger.error("Mapserver 地址格式错误： {}", url);
        }
    }
}
