package com.northpool.devtool.model;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.RuntimeMXBean;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * @author Bai Chenguang
 * @Date: 2022/06/14/ 上午 11:46
 * @Description
 */
public class JvmInfo {

    String version;
    String home;
    String userDir;
    String tmpDir;

    String startTime;
    String runTime;

    //堆内存
    String heapInitMemory;
    String heapUsageMemory;
    String heapCommitMemory;
    String heapMaxMemory;

    //非堆内存
    String nonHeapInitMemory;
    String nonHeapUsageMemory;
    String nonHeapCommitMemory;
    String nonHeapMaxMemory;


    RuntimeMXBean runtimeMX = ManagementFactory.getRuntimeMXBean();
    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");

    public JvmInfo() {
        this.version = System.getProperty("java.version");
        this.home = System.getProperty("java.home");
        this.tmpDir = System.getProperty("java.io.tmpdir");
        this.userDir = System.getProperty("user.dir");
        this.startTime = dateFormat.format(new Date(runtimeMX.getStartTime()));

        //堆内存
        MemoryMXBean memorymbean = ManagementFactory.getMemoryMXBean();
        MemoryUsage heapMemoryUsage = memorymbean.getHeapMemoryUsage();
        MemoryUsage nonHeapMemoryUsage = memorymbean.getNonHeapMemoryUsage();
        this.heapInitMemory = kb2mb(heapMemoryUsage.getInit());
        this.heapUsageMemory = kb2mb(heapMemoryUsage.getUsed());
        this.heapMaxMemory = kb2mb(heapMemoryUsage.getInit());
        this.heapCommitMemory = kb2mb(heapMemoryUsage.getCommitted());

        this.nonHeapInitMemory = kb2mb(nonHeapMemoryUsage.getInit());
        this.nonHeapUsageMemory = kb2mb(nonHeapMemoryUsage.getUsed());
        this.nonHeapMaxMemory = kb2mb(nonHeapMemoryUsage.getMax());
        this.nonHeapCommitMemory = kb2mb(nonHeapMemoryUsage.getCommitted());
    }

    public String getVersion() {
        return version;
    }

    public String getHome() {
        return home;
    }

    public String getStartTime() {
        return startTime;
    }

    public String getRunTime() {
        return formatDuring(runtimeMX.getUptime());
    }

    public String getHeapInitMemory() {
        return heapInitMemory;
    }

    public String getHeapUsageMemory() {
        return heapUsageMemory;
    }

    public String getHeapCommitMemory() {
        return heapCommitMemory;
    }

    public String getHeapMaxMemory() {
        return heapMaxMemory;
    }

    public String getNonHeapInitMemory() {
        return nonHeapInitMemory;
    }

    public String getNonHeapUsageMemory() {
        return nonHeapUsageMemory;
    }

    public String getNonHeapCommitMemory() {
        return nonHeapCommitMemory;
    }

    public String getNonHeapMaxMemory() {
        return nonHeapMaxMemory;
    }

    public String getUserDir() {
        return userDir;
    }

    public String getTmpDir() {
        return tmpDir;
    }

    static String kb2mb(Long kb){
        return Math.toIntExact(kb / 1024 / 1024) + " MB";
    }

    public static String formatDuring(long mss) {
        long days = mss / (1000 * 60 * 60 * 24);
        long hours = (mss % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60);
        long minutes = (mss % (1000 * 60 * 60)) / (1000 * 60);
        long seconds = (mss % (1000 * 60)) / 1000;
        return days + " 天 " + hours + " 小时 " + minutes + " 分钟 " + seconds + " 秒 ";
    }
}
