package com.northpool.devtool.model;

import com.northpool.devtool.model.abstractclass.AbstractNetConnect;
import com.northpool.resources.utils.MongoClientURI;

import java.util.List;

/**
 * @author Bai Chenguang
 * @Date: 2022/06/20/ 下午 4:57
 * @Description
 */
public class MongoDbInfo extends AbstractNetConnect {
    String uri;
    String username;

    public MongoDbInfo(String uri) {
        super(uri);
    }

    public String getUri() {
        return uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    @Override
    public void init(String uri) {
        this.uri = uri;
        this.hosts = getHostList();
    }

    public List<String> getHostList(){
        MongoClientURI clientURI = new MongoClientURI(uri);
        return clientURI.getHosts();
    }

}
