package com.northpool.devtool.model;

import com.northpool.devtool.model.abstractclass.AbstractNetConnect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.net.URI;
import java.net.URISyntaxException;

/**
 * @author Bai Chenguang
 * @Date: 2022/06/20/ 下午 5:01
 * @Description
 */
public class ZookeeperInfo extends AbstractNetConnect {
    private static Logger logger = LoggerFactory.getLogger(ZookeeperInfo.class);
    String address;
    String root;
    Integer timeout;

    public ZookeeperInfo(String address, String root, Integer timeout) {
        super(address);
        this.address = address;
        this.root = root;
        this.timeout = timeout;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getRoot() {
        return root;
    }

    public void setRoot(String root) {
        this.root = root;
    }

    public Integer getTimeout() {
        return timeout;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    @Override
    public void init(String uri) {
        try {
            URI _uri = new URI("http://" + uri);
            this.ip = _uri.getHost();
            this.port = _uri.getPort();
        } catch (URISyntaxException e) {
            logger.error("zookeeper 地址有误，请检查");
        }
    }
}
