package com.northpool.service.client;

import java.io.InputStream;

import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class InfoCode {
	final public static String XMLTEMPLE = "<InfoCode><State>{state}</State><ErrorCode>{errorCode}</ErrorCode><Msg>{msg}</Msg></InfoCode>";
	
	public enum State{
		error,timeout,success,message,clientError
	} 
	protected Integer errorCode;
	protected String msg;	
	
	public InfoCode(){
		
	}
	
	public void setErrorCode(Integer errorCode) {
		this.errorCode = errorCode;
	}

	public void setMsg(String msg) {
		this.msg = msg;
	}

	public void setState(State state) {
		this.state = state;
	}

	public Integer getErrorCode() {
		return errorCode;
	}
	public State getState() {
		return state;
	}

	protected State state;
	
	public String getMsg() {
		return msg;
	}
	
	public InfoCode(State state,Integer errorCode,String msg){
		this.state = state;
		this.errorCode = errorCode;
		this.msg = msg;
	}
	
	public String toXML(){
		String xml = XMLTEMPLE;
		xml = xml.replace("{state}", this.state.name());
		xml = xml.replace("{errorCode}", String.valueOf(this.errorCode));
		xml = xml.replace("{msg}", String.valueOf(this.msg));
		return xml;
	}
	
	public static State getState(String stateStr){
		for(State state : State.class.getEnumConstants()){
			if(state.name().equalsIgnoreCase(stateStr)){
				return state;
			}
		}
		return null;
	}
	
	public static InfoCode FROM_XML(InputStream in) throws DocumentException{
		SAXReader reader = new SAXReader();
		Document document = reader.read(in);
		Element root = document.getRootElement();
		String stateStr = root.elementText("State");
		State state = getState(stateStr);
		Integer errorCode = null;
		try{
			errorCode = Integer.valueOf(root.elementText("ErrorCode"));
		}catch(Exception e){
			
		}
		String msg = root.elementText("msg");
		
		InfoCode infoCode = new InfoCode(state,errorCode,msg);
		return infoCode;
	}
}
