package com.northpool.service.config.data_service;


import com.northpool.bean.Idable;
import com.northpool.bean.Jsonable;
import com.northpool.bean.Markable;
import com.northpool.resources.datatable.IField;
import com.northpool.resources.datatable.ISpatialField;
import com.northpool.resources.datatable.ITable;
import com.northpool.service.client.Client;
import com.northpool.service.config.*;
import com.northpool.service.config.data_service.tileInfo.IAreaTileInfo;
import com.northpool.service.config.data_service.tileInfo.IFeatureTileInfo;
import com.northpool.service.config.data_source.IDataSourceInService;
import com.northpool.service.config.vector_service.storage.IStorageInfo;
import com.northpool.spatial.Constants;

import java.util.List;
import java.util.Map;

public interface IDataService extends IService, Jsonable, Markable, Idable<String>, IDocumentAble, CanStartStop, IVersionAble, IBeanShell<DataServiceBean> {
	List<FieldsConfig> getFields();

	public IDataSourceInService getDataSource();

	public String getDataSourceId();

	public Boolean getReadOnly();
	public Map<String,IField> getFieldMap();
	public ISpatialField getSpatialField();
	public ISpatialField getSpatialFieldByTable();
	public Constants.GEO_TYPE getGeoType();
	public String getSpatialFieldOriName();
	public String getSpatialFieldName();
	public FieldsConfig getIdField();
	public String getIdFieldName();
	public Map<String, String> getAliasMap();
	public String[] getAliasFiledArr();
	public String getTableName();
	public String getName();
	public ITable getTable() throws Exception;
	public void refresh();
	public static IDataService create(Client client,DataServiceBean dataService){
		return new DataServiceShell(client,dataService);
	}

	public void addStorageInfo(IStorageInfo storageInfo);

	public IStorageInfo getStorageInfo();

    IAreaTileInfo getAreaTileInfo();

    void addAreaTileInfo(IAreaTileInfo areaTileInfo);

	IFeatureTileInfo getFeatureTileInfo();

	void addFeatureTileInfo(IFeatureTileInfo featureTileInfo);

	public String getStorageName();

	String getAreaStorageName();

    String getFeatureStorageName();

    public String getLabelStorageName();

	public Client getClient();

	public void setFilter(String filter);


}
