/**
　 * <p>Title: RasterDataServiceBean.java</p>
　 * <p>Description: </p>
　 * <p>Copyright: Copyright (c) 2021</p>
　 * <p>Company: northpool</p>
　 * @author chy
　 * @date 2021年11月30日
　 * @version 1.0
*/
package com.northpool.service.config.data_service.raster;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.northpool.resources.Image;
import com.northpool.resources.image.raster.RasterImageConnection;
import com.northpool.resources.image.raster.RasterImageGDALShell;
import com.northpool.service.config.CanStartStop.STATE_TYPE;
import com.northpool.service.config.Constants.RASTER_HANDLE_TYPE;
import com.northpool.service.config.Constants.SERVICE_TYPE;
import com.northpool.service.config.vector_service.storage.StorageInfoBean;
import com.northpool.spatial.grid.QuadtreeGrid;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

import java.io.IOException;
import java.util.List;

/**
 * @author chy
 *
 */
public class RasterDataServiceBean {
    /**
     * 影像数据服务ID
     */
    private String id;
    /**
     * 名称
     */
    private String name;
    /**
     * 影像数据服务文件列表，有序
     */
    private List<Image> images;

    /**
     * 使用波段信息，数组中的波段号有序，波段号从1开始计数，
     * 若为空表示使用文件中所有波段，并保持默认波段顺序
     */
    protected Integer[] bands;
    /**
     * 是否为地形数据服务
     */
    private Boolean terrain;
    /**
     * 栅格数据坐标系
     */
    private Integer srid;
    /**
     * 栅格NO_DATA_VALUE值
     */
    private Double[] noDataValue;
    /**
     * 栅格处理方式
     */
    private RASTER_HANDLE_TYPE rasterHandleType;
    /**
     * 开始层级
     */
    private Integer startLevel;
    /**
     * 开始分辨率
     */
    private Double startResolution;
    /**
     * 结束层级
     */
    private Integer endLevel;
    /**
     * 结束分辨率
     */
    private Double endResolution;
    /**
     * 栅格四至范围
     */
    private Double[] bbox;
    /**
     * 输出格网
     */
    private QuadtreeGrid grid;
    /**
     * 格网
     */
    private String gridTreeName;
    /**
     * 重采样配置
     */
    private List<ResampleConfig> resampleConfigs;
    /**
     * 去黑边配置
     */
    private List<DispelEdgeConfig> dispelEdgedConfigs;
    /**
     * 匀色模板
     */
    private UniformColorTemplate uniformColorTemplate;
    
    private SERVICE_TYPE serviceType;
    
    private STATE_TYPE state = STATE_TYPE.standby;
    
    private StorageInfoBean storageInfo;
    
    private String version;
    
    private Integer bandCount;
    /**
     * 波段值转为RGBA脚本
     */
    private String bandValueToRGBAScript;

    /**
     * 影像文件合并脚本
     */
    private String mergeScript;

    
    RasterDataServiceBean() {
        
    }
    
    /**
     * 
     * @param id String 影像数据服务ID，全局唯一
     * @param name String 影像数据服务名称
     * @param images List<Image> 要素属性
     */
    public RasterDataServiceBean(String id, String name, List<Image> images) {
        this(id, name, images, false, null);
    }
    
    public RasterDataServiceBean(String id, String name, List<Image> images, Integer[] bands) {
        this(id, name, images, false, bands);
    }
    
    public RasterDataServiceBean(String id, String name, List<Image> images, boolean isTerrain, Integer[] bands) {
        if(StringUtils.isBlank(id)) {
            throw new RuntimeException("影像数据服务id不允许为空");
        }
        if(images == null || images.isEmpty() || images.get(0) == null || images.get(0).empty()) {
            throw new RuntimeException("影像数据服务必须包含至少一个栅格文件");
        }
        String fileName = images.get(0).getFileName();
        RasterImageConnection connection = new RasterImageConnection(fileName);
        RasterImageGDALShell gdalShell = connection.getRasterImageGDALShell();
        try {
            gdalShell.load();
            this.bandCount = gdalShell.getBandCount();
            if(0 == this.bandCount) {
                throw new RuntimeException("非法影像文件：缺少波段（通道）信息");
            }
            this.noDataValue = gdalShell.getNoDataValue();
            this.srid = Integer.parseInt(gdalShell.getSrid());
        } catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        } catch (NumberFormatException e) {
            throw new RuntimeException(StringUtils.join("影像数据 ", fileName, " 的坐标系代码 ", gdalShell.getSrid(), " 不是标准的整型代码"));
        }
        
        this.id = id;
        this.name = name;
        this.images = images;
        this.terrain = isTerrain;
        this.bbox = this.calculateBBox();

        if(ArrayUtils.isNotEmpty(bands)) {
            for(Integer band : bands) {
                if(band <= 0 || band > this.bandCount) {
                    throw new RuntimeException(StringUtils.join("栅格文件坡段数为：【", this.bandCount,"】；不存在波段：【",band,"】"));
                }
            }
            this.bands = bands;
        }
        
        // 若为地形数据服务，则必须指定使用波段序号
        if(isTerrain) {
            if(ArrayUtils.isEmpty(bands)) {
                this.bands = new Integer[] {1}; //默认使用第一个波段作为地形数据
            } else {
                int terrainBand = bands[0];
                if(terrainBand <= 0 || terrainBand > this.bandCount) {
                    throw new RuntimeException(StringUtils.join("栅格文件坡段数为：【", this.bandCount,"】；不存在波段：【",terrainBand,"】"));
                }
                this.bands = new Integer[] {terrainBand};
            }
            this.serviceType = SERVICE_TYPE.terrain_data_service;
        } else {
            this.serviceType = SERVICE_TYPE.image_data_service;
        }
        
    }

    //public RasterDataServiceBean(String id, String name, List<Image> images, boolean isTerrain, Integer[] bands,RasterInfoShell rasterInfoShell) throws IOException, MapserverAccessException {
       /* if(StringUtils.isBlank(id)) {
            throw new RuntimeException("影像数据服务id不允许为空");
        }
        if(images == null || images.isEmpty() || images.get(0) == null || images.get(0).empty()) {
            throw new RuntimeException("影像数据服务必须包含至少一个栅格文件");
        }
        this.bandCount = rasterInfoShell.getBandCount();
        if(0 == this.bandCount) {
            throw new RuntimeException("非法影像文件：缺少波段（通道）信息");
        }
        this.noDataValue = rasterInfoShell.getNoDataValue();
        this.srid = rasterInfoShell.getSrid();

        this.id = id;
        this.name = name;
        this.images = images;
        this.terrain = isTerrain;
        this.bbox = this.calculateBBox();

        if(ArrayUtils.isNotEmpty(bands)) {
            for(Integer band : bands) {
                if(band <= 0 || band > this.bandCount) {
                    throw new RuntimeException(StringUtils.join("栅格文件坡段数为：【", this.bandCount,"】；不存在波段：【",band,"】"));
                }
            }
            this.bands = bands;
        }

        // 若为地形数据服务，则必须指定使用波段序号
        if(isTerrain) {
            if(ArrayUtils.isEmpty(bands)) {
                this.bands = new Integer[] {1}; //默认使用第一个波段作为地形数据
            } else {
                int terrainBand = bands[0];
                if(terrainBand <= 0 || terrainBand > this.bandCount) {
                    throw new RuntimeException(StringUtils.join("栅格文件坡段数为：【", this.bandCount,"】；不存在波段：【",terrainBand,"】"));
                }
                this.bands = new Integer[] {terrainBand};
            }
            this.serviceType = SERVICE_TYPE.terrain_data_service;
        } else {
            this.serviceType = SERVICE_TYPE.image_data_service;
        }
*/
    //}
    
    /**
     * 计算影像数据服务bbox
     * @return
     */
    private Double[] calculateBBox() {
        Double[] bbox = new Double[4];
        for (int i = 0, len = this.images.size(); i < len; i++) {
            Image image = this.images.get(i);
            Double[] imageBbox = image.getBbox();
            if (null == bbox[0] || imageBbox[0] < bbox[0]) {
                bbox[0] = imageBbox[0];
            }
            if (null == bbox[1] || imageBbox[1] < bbox[1]) {
                bbox[1] = imageBbox[1];
            }
            if (null == bbox[2] || imageBbox[2] > bbox[2]) {
                bbox[2] = imageBbox[2];
            }
            if (null == bbox[3] || imageBbox[3] > bbox[3]) {
                bbox[3] = imageBbox[3];
            }
        }
        return bbox;
    }
    
    public String getId() {
        return id;
    }
    public void setId(String id) {
        this.id = id;
    }
    public String getName() {
        return name;
    }
    public void setName(String name) {
        this.name = name;
    }
    public List<Image> getImages() {
        return images;
    }
    public void setImages(List<Image> images) {
        this.images = images;
    }
    public Boolean isTerrain() {
        return terrain;
    }

    public void setTerrain(Boolean terrain) {
        this.terrain = terrain;
    }

    public Integer getSrid() {
        return srid;
    }
    public void setSrid(Integer srid) {
        this.srid = srid;
    }
    public Double[] getNoDataValue() {
        return noDataValue;
    }
    public void setNoDataValue(Double[] noDataValue) {
        this.noDataValue = noDataValue;
    }
    public RASTER_HANDLE_TYPE getRasterHandleType() {
        return rasterHandleType;
    }
    public void setRasterHandleType(RASTER_HANDLE_TYPE rasterHandleType) {
        this.rasterHandleType = rasterHandleType;
    }
    public Integer getStartLevel() {
        return startLevel;
    }
    public void setStartLevel(Integer startLevel) {
        this.startLevel = startLevel;
    }
    public Double getStartResolution() {
        return startResolution;
    }
    public void setStartResolution(Double startResolution) {
        this.startResolution = startResolution;
    }
    public Integer getEndLevel() {
        return endLevel;
    }
    public void setEndLevel(Integer endLevel) {
        this.endLevel = endLevel;
    }
    public Double getEndResolution() {
        return endResolution;
    }
    public void setEndResolution(Double endResolution) {
        this.endResolution = endResolution;
    }
    public Double[] getBbox() {
        return bbox;
    }
    public void setBbox(Double[] bbox) {
        this.bbox = bbox;
    }
    public QuadtreeGrid getGrid() {
        return grid;
    }
    public void setGrid(QuadtreeGrid grid) {
        this.grid = grid;
    }
    public List<ResampleConfig> getResampleConfigs() {
        return resampleConfigs;
    }

    public void setResampleConfigs(List<ResampleConfig> resampleConfigs) {
        this.resampleConfigs = resampleConfigs;
    }

    public List<DispelEdgeConfig> getDispelEdgedConfigs() {
        return dispelEdgedConfigs;
    }

    public void setDispelEdgedConfigs(List<DispelEdgeConfig> dispelEdgedConfigs) {
        this.dispelEdgedConfigs = dispelEdgedConfigs;
    }

    public UniformColorTemplate getUniformColorTemplate() {
        return uniformColorTemplate;
    }
    public void setUniformColorTemplate(UniformColorTemplate uniformColorTemplate) {
        this.uniformColorTemplate = uniformColorTemplate;
    }
    public SERVICE_TYPE getServiceType() {
        return serviceType;
    }
    public STATE_TYPE getState() {
        return state;
    }
    public void setState(STATE_TYPE state) {
        this.state = state;
    }
    
    public StorageInfoBean getStorageInfo() {
        return storageInfo;
    }

    public void setStorageInfo(StorageInfoBean storageInfo) {
        this.storageInfo = storageInfo;
    }

    public String getVersion() {
        return version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String toJson() {
        return JSON.toJSONString(this, SerializerFeature.IgnoreErrorGetter);
    }

    public String images() {
        StringBuilder imageStringBuilder = new StringBuilder();
        for(Image image : this.images) {
            imageStringBuilder.append(image.getDataSourceId());
            imageStringBuilder.append(image.getFileName());
        }
        return imageStringBuilder.toString();
    }

    public String getGridTreeName() {
        return gridTreeName;
    }

    public void setGridTreeName(String gridTreeName) {
        this.gridTreeName = gridTreeName;
    }

    public String getGridName() {
       /* QuadtreeImpl quad = (QuadtreeImpl) this.grid;
        if(quad == null) {
            return null;
        }

        return quad.getName();*/
       return this.gridTreeName;
    }

    public Integer[] getBands() {
        return bands;
    }

    public void setBands(Integer[] bands) {
        this.bands = bands;
    }
    
    public Integer getBandCount() {
        return bandCount;
    }

    public void setBandCount(Integer bandCount) {
        this.bandCount = bandCount;
    }

    public void setServiceType(SERVICE_TYPE serviceType) {
        this.serviceType = serviceType;
    }

    public String getBandValueToRGBAScript() {
        return bandValueToRGBAScript;
    }

    public void setBandValueToRGBAScript(String bandValueToRGBAScript) {
        this.bandValueToRGBAScript = bandValueToRGBAScript;
    }

    public String getMergeScript() {
        return mergeScript;
    }

    public void setMergeScript(String mergeScript) {
        this.mergeScript = mergeScript;
    }


    @Override
    public boolean equals(Object o) {
        if (this == o) return true;

        if (o == null || getClass() != o.getClass()) return false;

        RasterDataServiceBean that = (RasterDataServiceBean) o;

        return new EqualsBuilder()
                .append(this.serviceType, that.getServiceType())
                .append(this.srid, that.getSrid())
                .append(this.getGridName(), that.getGridName())
                .append(this.terrain, that.isTerrain())
                .append(this.rasterHandleType, that.getRasterHandleType())
                .append(this.images(), that.images())
                .isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(31, 51)
                .append(this.serviceType)
                .append(this.srid)
                .append(this.getGridName())
                .append(this.rasterHandleType)
                .append(this.terrain)
                .append(this.rasterHandleType)
                .append(this.images())
                .toHashCode();
    }
}
