/**
　 * <p>Title: RasterDataSetShell.java</p>
　 * <p>Description: </p>
　 * <p>Copyright: Copyright (c) 2021</p>
　 * <p>Company: northpool</p>
　 * @author chy
　 * @date 2021年12月22日
　 * @version 1.0
*/
package com.northpool.service.config.raster_service.dataset;

import com.northpool.service.client.Client;
import com.northpool.service.config.data_service.raster.IRasterDataService;

/**
 * @author chy
 *
 */
public class RasterDataSetShell implements IRasterDataSet {

    protected RasterDataSetBean dataSet;
    
    protected Client client;
    
    protected IRasterDataService rasterDataService;
    
    public RasterDataSetShell(Client client, RasterDataSetBean dataSet) {
        this.client = client;
        this.dataSet = dataSet;
        this.setDataService();
    }
    
    private void setDataService() {
        if(this.rasterDataService == null) {
            String dataServiceId = this.dataSet.getDataServiceId();
            this.rasterDataService = this.client.getRasterDataServiceManager().get(dataServiceId);
            if(this.rasterDataService == null) {
                throw new RuntimeException(String.format("数据服务%s不存在", dataServiceId));
            }
        }
    }
    
    @Override
    public String getSpatialFilter() {
        return this.dataSet.getSpatialFilter();
    }

    @Override
    public IRasterDataService getRasterDataService() {
        return this.rasterDataService;
    }

}
