package com.northpool.service.config.vector_service.storage;

import org.apache.commons.lang3.StringUtils;

import com.mongodb.client.model.CreateCollectionOptions;
import com.northpool.resources.MongodbFactory;
import com.northpool.resources.datasource.MongodbDataSource;
import com.northpool.service.client.Client;
import com.northpool.service.config.data_source.IDataSourceInService;
import com.northpool.service.xmlloader.vectorservice.VectorServiceLoader;

public class StorageInfoShell implements IStorageInfo {

    protected StorageInfoBean bean;

    protected Client client;


    public StorageInfoShell(Client client, StorageInfoBean storageBean){
        this.client = client;
        this.bean = storageBean;
    }

    @Override
    public IDataSourceInService getDataSource(){
        IDataSourceInService dataSourceInService = this.client.getDataSourcesManager().get(bean.getDataSourceId());
        if(dataSourceInService == null){
            throw new RuntimeException(String.format("数据源%s不存在", bean.getDataSourceId()));
        }
        return dataSourceInService;
    }


    @Override
    public StorageInfoBean getBean() {
        return bean;
    }

    @Override
    public Integer getStartLevel() {
        return bean.getStartLevel();
    }

    @Override
    public Integer getEndLevel() {
        return bean.getEndLevel();
    }

    public String getStorageName() {
        return bean.getStorageName();
    }


    public String getLabelStorageName() {
        return bean.getLabelStorageName();
    }

    @Override
    public Boolean isCompleted() {
        return bean.isCompleted();
    }

    @Override
    public void setCompleted(boolean completed) {
        this.bean.setCompleted(completed);
    }

    @Override
    public void drop() {
        IDataSourceInService dataSourceInService = this.client.getDataSourcesManager().get(bean.getDataSourceId());
        if (dataSourceInService != null){
            MongodbFactory factory = ((MongodbDataSource)dataSourceInService.getBean()).factory();
            factory.dropCollection(this.getStorageName());
            if (this.getLabelStorageName() != null){
                factory.dropCollection(this.getLabelStorageName());
            }
        }
    }

    @Override
    public void rename(String newName) {
        IDataSourceInService dataSourceInService = this.client.getDataSourcesManager().get(bean.getDataSourceId());
        if (dataSourceInService != null){
            MongodbFactory factory = ((MongodbDataSource)dataSourceInService.getBean()).factory();
            String storageName = this.getStorageName();
            String newStorageName = StringUtils.join(VectorServiceLoader.STORAGE_PREFIX, newName, VectorServiceLoader.LAYER_SUFFIX);
            if(factory.collectionExist(storageName)) {
                factory.renameCollection(storageName, newStorageName);
            } else {
                CreateCollectionOptions options = new CreateCollectionOptions();
                factory.createCollection(newStorageName, options);
            }
            this.bean.setStorageName(newStorageName);
        }
    }

    @Override
    public void renameLabel(String newName) {
        IDataSourceInService dataSourceInService = this.client.getDataSourcesManager().get(bean.getDataSourceId());
        if (dataSourceInService != null){
            MongodbFactory factory = ((MongodbDataSource)dataSourceInService.getBean()).factory();
            String layerStorageName = this.getLabelStorageName();
            String newLayerStorageName = StringUtils.join(VectorServiceLoader.STORAGE_PREFIX, newName, VectorServiceLoader.LABEL_SUFFIX);
            if(factory.collectionExist(layerStorageName)) {
                factory.renameCollection(layerStorageName, newLayerStorageName);
            }
            
            this.bean.setLabelStorageName(newLayerStorageName);
        }
    }

}
