/**
　 * <p>Title: RasterDataServiceZkDao.java</p>
　 * <p>Description: </p>
　 * <p>Copyright: Copyright (c) 2021</p>
　 * <p>Company: northpool</p>
　 * @author chy
　 * @date 2021年12月01日
　 * @version 1.0
*/
package com.northpool.service.dao.data_service.raster;

import java.util.List;

import org.apache.curator.framework.api.transaction.CuratorOp;
import org.apache.curator.framework.api.transaction.TransactionOp;

import com.northpool.service.client.Client;
import com.northpool.service.config.data_service.raster.IRasterDataService;
import com.northpool.service.config.data_service.raster.RasterDataServiceBuilder;
import com.northpool.service.dao.AbtractServiceZkDao;
import com.northpool.structure.queryhashtable.QueryHashTableHeap;

/**
 * @author chy
 *
 */
public class RasterDataServiceZkDao extends AbtractServiceZkDao<IRasterDataService, RasterDataServiceBuilder> {
    public RasterDataServiceZkDao(String idFieldName, RasterDataServiceBuilder beanBuilder, QueryHashTableHeap<String, IRasterDataService> table, Client client, String managerRoot, Boolean readOnly) {
        super(idFieldName, beanBuilder, table, client, managerRoot, readOnly);
    }

    protected void AddExtendsInfo2BeanNode(String path, List<CuratorOp> iList, TransactionOp transaction, IRasterDataService dataService)throws Exception {
        super.AddExtendsInfo2BeanNode(path, iList, transaction, dataService);
        CuratorOp createOp = transaction.create().forPath(path + "/read_only", dataService.getReadOnly().toString().getBytes());
        iList.add(createOp);
    }
}
