/**
　 * <p>Title: ImageServiceManager.java</p>
　 * <p>Description: </p>
　 * <p>Copyright: Copyright (c) 2021</p>
　 * <p>Company: northpool</p>
　 * @author chy
　 * @date 2021年12月22日
　 * @version 1.0
*//*

package com.northpool.service.manager.image_service;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

import org.apache.commons.lang3.StringUtils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.northpool.service.config.data_service.raster.RasterDataServiceBean;
import com.northpool.service.config.image_service.ImageServiceBuilder;
import com.northpool.service.config.raster_service.IRasterService;
import com.northpool.service.config.raster_service.RasterServiceBean;
import com.northpool.service.config.raster_service.dataset.IRasterDataSet;
import com.northpool.service.config.raster_service.layer.IRasterLayer;
import com.northpool.service.config.vector_service.storage.IStorageInfo;
import com.northpool.service.dao.image_service.ImageServiceMongoDao;
import com.northpool.service.dao.image_service.ImageServiceZkDao;
import com.northpool.service.manager.abstractclass.ServiceManager;
import com.northpool.service.manager.abstractclass.ZKException;

*/
/**
 * @author chy
 *
 *//*

public class ImageServiceManager extends ServiceManager<IRasterService, ImageServiceBuilder> implements IImageServiceManager {

    protected static final String MANAGER_ROOT = "image_service";

    protected static final String MONGO_COLLECTION_NAME = "TAB_MAPENGINE_SERVER_INFO";

    public ImageServiceManager() {
        super("id", new ImageServiceBuilder(), MANAGER_ROOT);
    }

    public void init() {
        super.init();
        this.beanBuilder.setClient(client);
        this.mongoDao = new ImageServiceMongoDao(client.initMongoClient(), MONGO_COLLECTION_NAME, "id", beanBuilder);
        if(client.getZoo() != null) {
            this.zkDao = new ImageServiceZkDao(idFieldName, beanBuilder,
                    table, client, managerRoot, readOnly, this);
            this.zkDao.init();
            try {
                this.zkDao.syncFromZK();
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
    
    @Override
    public void register(IRasterService imageService) throws ZKException {
        this.checkInvalid(imageService);
        
        super.doAdd(imageService);
        
    }
    */
/**
     * 后续补充
     * @param imageService
     *//*

    protected void checkInvalid(IRasterService imageService) {
        
    }

    public IRasterService get(String id) {
        IRasterService service = super.get(id);
        return service;
    }
    
    @Override
    public String getJSON(String id) {
        IRasterService imageService = this.get(id);
        if (imageService == null){
            return null;
        }

        RasterServiceBean serviceBean = imageService.getBean();
        JSONObject jsonService = (JSONObject)JSON.toJSON(serviceBean);
        
        this.addFilesToService(jsonService, imageService);
        
        return JSON.toJSONString(jsonService, SerializerFeature.DisableCircularReferenceDetect);
    }
    
    private void addFilesToService(JSONObject jsonService, IRasterService imageService) {
        StringBuilder spatialFilter = new StringBuilder();
        LinkedHashMap<String, IRasterLayer> layerMap = imageService.getLayerMap();
            
        List<String> files = layerMap.entrySet().stream().flatMap(entry -> {
                IRasterLayer layer = entry.getValue();
                int begin = layer.getBeginLevel();
                if(jsonService.get("beginLevel") == null || begin < (int)jsonService.get("beginLevel")) {
                    jsonService.put("beginLevel", begin);
                }
                int end = layer.getEndLevel();
                if(jsonService.get("endLevel") == null || end > (int)jsonService.get("endLevel")) {
                    jsonService.put("endLevel", end);
                }
                
                return layer.getLevelMap().values().stream().map(level -> {
                    IRasterDataSet dataSet = level.getDataSet();
                    String filter = dataSet.getSpatialFilter();
                    if (StringUtils.isNotBlank(filter) && spatialFilter.indexOf(filter) == -1) {
                        spatialFilter.append(filter);
                        spatialFilter.append(" AND ");
                    }
                    RasterDataServiceBean dataService = dataSet.getRasterDataService().getBean();
                    if (jsonService.get("srid") == null) {
                        jsonService.put("srid", dataService.getSrid());
                    }
                    
                    if (jsonService.get("bandCount") == null) {
                        jsonService.put("bandCount", dataService.getBandCount());
                    }
                    
                    if (jsonService.get("bands") == null) {
                        jsonService.put("bands", dataService.getBands());
                    }
                    
                    if (jsonService.get("rasterHandleType") == null) {
                        jsonService.put("rasterHandleType", dataService.getRasterHandleType());
                    }
                    
                    if (jsonService.get("noDataValue") == null) {
                        jsonService.put("noDataValue", dataService.getNoDataValue());
                    }
                    
                    if (jsonService.get("dispelEdgedConfigs") == null) {
                        jsonService.put("dispelEdgedConfigs", dataService.getDispelEdgedConfigs());
                    }
                    
                    if (jsonService.get("resampleConfigs") == null) {
                        jsonService.put("resampleConfigs", dataService.getResampleConfigs());
                    }
                    if (jsonService.get("bandValueToRGBAScript") == null) {
                        jsonService.put("bandValueToRGBAScript", dataService.getBandValueToRGBAScript());
                    }
                    if (jsonService.get("gridTreeName") == null) {
                        jsonService.put("gridTreeName", dataService.getGridTreeName());
                    }
                    return dataService;
                });
            }).distinct().flatMap(dataService -> dataService.getImages().stream())
            .distinct().map(image -> image.getFileName())
            .collect(Collectors.toList());
        
        jsonService.put("files", files);
        jsonService.put("spatialFilter", spatialFilter.toString());
    }
    
    @Override
    public void unRegister(String id) throws ZKException {
        super.doRemove(id);
    }

    @Override
    public void update(IRasterService imageService) throws ZKException {
        this.checkInvalid(imageService);
        super.doUpdate(imageService);
    }

    @Override
    public boolean checkVersion(String id, String version) {
        IRasterService imageService = this.get(id);
        if(imageService != null) {
            return Objects.equals(version, imageService.getVersion());
        }
        return false;
    }

    @Override
    public void rename(String oldName, String newName) throws ZKException {
        IRasterService old = this.get(oldName);
        if(old == null) {
            throw new RuntimeException(StringUtils.join("服务 ", oldName, " 不存在"));
        }

        IRasterService newService = this.get(newName);
        if(newService != null) {
            throw new RuntimeException(StringUtils.join("服务 ", newService, " 已存在"));
        }
        
        IStorageInfo storageInfo = old.getStorageInfo();
        if(storageInfo != null) {
            storageInfo.rename(newName);
            storageInfo.renameLabel(newName);
        }

        this.unRegister(oldName);
        old.getBean().setId(newName);
        this.register(old);
    }
    
    */
/**
     * 级联删除服务相关资源
     * @param id 服务ID
     * @throws Exception 
     *//*

    public void unRegisterCascade(String id) throws Exception {

        IRasterService service = this.get(id);
        
        IStorageInfo storageInfo = service.getStorageInfo();
        if(storageInfo != null) {
            storageInfo.drop();
        }
        
        this.unRegister(id);
    }
}
*/
