package com.northpool.devtool.AbnormalCheck;

import com.northpool.devtool.AbnormalCheck.abstractclass.AbstractCheck;
import com.northpool.devtool.model.JvmInfo;
import com.northpool.devtool.utils.NetUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.net.UnknownHostException;

/**
 * @author Bai Chenguang
 * @Date: 2022/06/23/ 下午 8:03
 * @Description
 */
public class PortCheck extends AbstractCheck implements IAbnormalCheck {
    private static Logger logger = LoggerFactory.getLogger(PortCheck.class);

    String host = "127.0.0.1";
    Integer port;

    static PortCheck inst;

    public PortCheck(Integer port) {
        this.port = port;
    }

    public static PortCheck getInst(Integer port) {
        if (inst == null) {
            inst = new PortCheck(port);
        } else {
            inst.port = port;
        }
        return inst;
    }

    @Override
    public void check() {
        try {
            boolean flag = NetUtils.isPortUsing(host, port);
            if (flag) {
                logger.error("端口占用：{}, 请清理占用的端口进程或使用其他的端口启动", port);
                logger.error("配置项为 server.port: {}", 8080);
                super.shutdown();
            }
        } catch (UnknownHostException e) {
            logger.error(e.getMessage());
        }
    }
}
