package com.northpool.devtool.AbnormalCheck;

import com.northpool.devtool.AbnormalCheck.abstractclass.AbstractCheck;
import com.northpool.devtool.model.ZookeeperInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author Bai Chenguang
 * @Date: 2022/06/23/ 下午 3:39
 * @Description
 */
public class ZookeeperCheck extends AbstractCheck implements IAbnormalCheck {
    private static Logger logger = LoggerFactory.getLogger(ZookeeperCheck.class);

    private String uri;

    static ZookeeperCheck inst;

    public ZookeeperCheck(String uri) {
        this.uri = uri;
    }

    public static ZookeeperCheck getInst(String uri) {
        if (inst == null) {
            inst = new ZookeeperCheck(uri);
        } else {
            inst.uri = uri;
        }
        return inst;
    }

    @Override
    public void check() {
        ZookeeperInfo zkInfo = new ZookeeperInfo(uri, null, null);
        if (!zkInfo.getConnect()) {
            logger.error("Zookeeper 服务无法连接 {}", uri);
            logger.error("1.请排查 Zookeeper 服务是否正常启动");
            logger.error("2.检查网络ip/端口是否开放");
            super.shutdown();
        }
    }
}
