/**
　 * <p>Title: RasterDataServiceBuilder.java</p>
　 * <p>Description: </p>
　 * <p>Copyright: Copyright (c) 2021</p>
　 * <p>Company: northpool</p>
　 * @author chy
　 * @date 2021年11月30日
　 * @version 1.0
*/
package com.northpool.service.config.data_service.raster;

import org.bson.Document;

import com.alibaba.fastjson.JSON;
import com.northpool.bean.JsonableBuilder;
import com.northpool.service.client.Client;
import com.northpool.service.manager.abstractclass.DocumentableBuilder;

/**
 * @author chy
 *
 */
public class RasterDataServiceBuilder implements JsonableBuilder<IRasterDataService>, DocumentableBuilder<IRasterDataService> {

    private Client client;
    
    public RasterDataServiceBuilder() {}
    
    RasterDataServiceBuilder(Client client) {
        this.client = client;
    }
    
    @Override
    public IRasterDataService fromDocument(Document str) throws Exception {
        str.remove("_id");
        return this.fromJson(str.toJson());
    }

    @Override
    public IRasterDataService fromJson(String json) throws Exception {
        RasterDataServiceBean dataService = JSON.parseObject(json, RasterDataServiceBean.class);
        
        RasterDataServiceShell shell = new RasterDataServiceShell(this.client, dataService);
        
        return shell;
    }

    public void setClient(Client client) {
        this.client = client;
    }
}
