/**
　 * <p>Title: RasterDataServiceShell.java</p>
　 * <p>Description: </p>
　 * <p>Copyright: Copyright (c) 2021</p>
　 * <p>Company: northpool</p>
　 * @author chy
　 * @date 2021年11月30日
　 * @version 1.0
*/
package com.northpool.service.config.data_service.raster;

import java.util.List;

import org.bson.Document;

import com.northpool.resources.Image;
import com.northpool.service.client.Client;
import com.northpool.service.config.Constants.SERVICE_TYPE;
import com.northpool.service.config.data_source.IDataSourceInService;
import com.northpool.service.config.vector_service.storage.IStorageInfo;
import com.northpool.service.config.vector_service.storage.StorageInfoBean;
import com.northpool.service.config.vector_service.storage.StorageInfoShell;

/**
 * @author chy
 *
 */
public class RasterDataServiceShell implements IRasterDataService {

    private Client client;
    
    private RasterDataServiceBean dataService;
    
    private IStorageInfo storageInfo;

    public RasterDataServiceShell(Client client, RasterDataServiceBean dataService) {
        this.client = client;
        this.dataService = dataService;
        this.storageInfo = this.createStorageInfo(dataService.getStorageInfo());
    }
    
    @Override
    public String getId() {
        return this.dataService.getId();
    }

    @Override
    public String getVersion() {
        return this.dataService.getVersion();
    }

    @Override
    public SERVICE_TYPE getServiceType() {
        return this.dataService.getServiceType();
    }

    @Override
    public String toJson() {
        return this.dataService.toJson();
    }

    @Override
    public String mark() {
        return this.getId();
    }

    @Override
    public Document toDocument() {
        return Document.parse(this.toJson());
    }

    @Override
    public void start() {
        this.dataService.setState(STATE_TYPE.run);
    }

    @Override
    public void stop() {
        this.dataService.setState(STATE_TYPE.stop);
    }

    @Override
    public String state() {
        return this.getState().name();
    }

    @Override
    public STATE_TYPE getState() {
        return this.dataService.getState();
    }

    @Override
    public void rollback(STATE_TYPE state) {
        this.dataService.setState(state);
    }

    @Override
    public void setVersion(String version) {
        this.dataService.setVersion(version);
    }

    @Override
    public Boolean getReadOnly() {
        return true;
    }

    @Override
    public RasterDataServiceBean getBean() {
        return this.dataService;
    }

    @Override
    public String getLayerName() {
        return this.dataService.getName();
    }

    @Override
    public String getName() {
        return this.dataService.getName();
    }

    @Override
    public Client getClient() {
        return this.client;
    }

    @Override
    public void refresh() {
        //更新影像数据服务信息
        IRasterDataService dataService = this.client.getRasterDataServiceManager().get(this.getId());
        if (dataService == null) {
            return;//此处应抛出异常
        }
        
        // 更新影像数据源信息
        this.dataService = dataService.getBean();
        List<Image> images = this.dataService.getImages();
        for(Image image : images) {
            String dataSourceId = image.getDataSourceId();
            IDataSourceInService dataSourceInService = this.getDataSource(dataSourceId);
            dataSourceInService.refresh();
        }
        
    }
    
    private IDataSourceInService getDataSource(String dataSourceId) {
        IDataSourceInService dataSource = this.client.getDataSourcesManager().get(dataSourceId);
        if(dataSource == null){
            throw new RuntimeException(String.format("没有dataSourceId为 %s 的数据源",dataSourceId));
        }
        return dataSource;
    }

    @Override
    public void addStorageInfo(IStorageInfo storageInfo) {
        this.storageInfo = storageInfo;
        this.getBean().setStorageInfo(storageInfo.getBean());
    }

    @Override
    public IStorageInfo getStorageInfo() {
        return this.storageInfo;
    }

    @Override
    public String getStorageName() {
        return this.dataService.getName() + "_" + this.dataService.getId();
    }
    
    private IStorageInfo createStorageInfo(StorageInfoBean storageInfo) {
        if (storageInfo != null) {
            return new StorageInfoShell(this.client, storageInfo);
        }
        return null;
    }

    @Override
    public Integer getSrid() {
        return this.dataService.getSrid();
    }
    
    @Override
    public boolean equals(Object obj) {
        if(this == obj) return true;
        if(obj == null || getClass() != obj.getClass()) return false;
        
        RasterDataServiceShell that = (RasterDataServiceShell) obj;
        return this.dataService.equals(that.getBean());
    }
    
}
