package com.northpool.service.config.vector_service;

import com.northpool.service.config.data_source.IDataSourceInService;

public interface ICacheable {
	/**
	 * 是否开启数据缓存
	 */
	public boolean needDataCache();
	/**
	 * 是否开启图片缓存
	 */
	public boolean needImgCache();
	
	
	//缓存策略
	
	/**
	 * 图片缓存配置脚本
	 */
	public String getImgScript();
	
	/**
	 * 获得数据缓存地址
	 * @return
	 */
	public IDataSourceInService getDataCacheSource();
	
	/**
	 * 获得图片缓存地址
	 * @return
	 */
	public IDataSourceInService getImgCacheSource(); 
	
	/**
	 * 获得数据缓存使用脚本
	 * @return
	 */
	public String getDataScript();

	public CacheInfoBean getCacheInfoBean();

	public void drop(String serverName, String styleId) throws Exception;
	
}
