package com.northpool.service.config.vector_service;


import com.northpool.service.config.CanStartStop.STATE_TYPE;
import com.northpool.service.config.Constants.SERVICE_TYPE;
import com.northpool.service.config.vector_service.dataset.DataSetBean;
import com.northpool.service.config.vector_service.layer.LayerBean;
import com.northpool.service.config.vector_service.storage.StorageInfoBean;
import com.northpool.service.config.vector_service.utfgrid.UtfgridInfoBean;

import java.util.Map;



public class VectorServiceBean  {
	/**
	 * ID
	 */
	protected String id;
	/**
	 * 名称
	 */
	protected String name;
	/**
	 * 四至范围
	 */
	protected String bbox;
	/**
	 * 更新版本
	 */
	protected String version;
	/**
	 * 格网
	 */
	protected String gridTreeName;

	protected double[] resolutions;

	protected int[] origin;
	/**
	 * 数据集map
	 */
	protected Map<String,DataSetBean> dataSetMap;
	/**
	 * 图层
	 */
	protected Map<String, LayerBean> layerMap;
	/**
	 * 类型
	 */
	protected final SERVICE_TYPE serviceType = SERVICE_TYPE.vector_service;
	/**
	 * 开始等级
	 */
	protected Integer beginLevel;
	/**
	 * 结束等级
	 */
	protected Integer endLevel;
	
	/**
	 * 缓存信息
	 */
	protected CacheInfoBean cacheInfo;

	protected StorageInfoBean storageInfo;

	protected UtfgridInfoBean utfgridInfo;
	
	
	protected STATE_TYPE state = STATE_TYPE.standby;
	
	public CacheInfoBean getCacheInfo() {
		return cacheInfo;
	}
	public void setCacheInfo(CacheInfoBean cacheInfo) {
		this.cacheInfo = cacheInfo;
	}
	public String getId() {
		return id;
	}
	public void setId(String id) {
		this.id = id;
	}
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	public String getBbox() {
		return bbox;
	}
	public void setBbox(String bbox) {
		this.bbox = bbox;
	}
	public String getVersion() {
		return version;
	}
	public void setVersion(String version) {
		this.version = version;
	}
	public String getGridTreeName() {
		return gridTreeName;
	}
	public void setGridTreeName(String gridTreeName) {
		this.gridTreeName = gridTreeName;
	}
	public Map<String, DataSetBean> getDataSetMap() {
		return dataSetMap;
	}
	public void setDataSetMap(Map<String, DataSetBean> dataSetMap) {
		this.dataSetMap = dataSetMap;
	}
	public Map<String, LayerBean> getLayerMap() {
		return layerMap;
	}
	public void setLayerMap(Map<String, LayerBean> layerMap) {
		this.layerMap = layerMap;
	}
	public Integer getBeginLevel() {
		return beginLevel;
	}
	public void setBeginLevel(Integer beginLevel) {
		this.beginLevel = beginLevel;
	}
	public Integer getEndLevel() {
		return endLevel;
	}
	public void setEndLevel(Integer endLevel) {
		this.endLevel = endLevel;
	}
	public SERVICE_TYPE getServiceType() {
		return serviceType;
	}

	public StorageInfoBean getStorageInfo() {
		return storageInfo;
	}

	public void setStorageInfo(StorageInfoBean storageInfo) {
		this.storageInfo = storageInfo;
	}

	public UtfgridInfoBean getUtfgridInfo() {
		return utfgridInfo;
	}

	public void setUtfgridInfo(UtfgridInfoBean utfgridInfo) {
		this.utfgridInfo = utfgridInfo;
	}

	public double[] getResolutions() {
		return resolutions;
	}

	public void setResolutions(double[] resolutions) {
		this.resolutions = resolutions;
	}

	public int[] getOrigin() {
		return origin;
	}

	public void setOrigin(int[] origin) {
		this.origin = origin;
	}
}
