package com.northpool.service.config.vector_service;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import org.bson.Document;

import com.alibaba.fastjson.JSON;
import com.northpool.service.client.Client;
import com.northpool.service.config.Constants.SERVICE_TYPE;
import com.northpool.service.config.data_service.FieldsConfig;
import com.northpool.service.config.data_service.IDataService;
import com.northpool.service.config.data_source.IDataSourceInService;
import com.northpool.service.config.vector_service.dataset.DataSetBean;
import com.northpool.service.config.vector_service.dataset.IDataSet;
import com.northpool.service.config.vector_service.layer.ILayer;
import com.northpool.service.config.vector_service.layer.ILayerLevel;
import com.northpool.service.config.vector_service.layer.LayerBean;
import com.northpool.service.config.vector_service.layer.LayerShell;
import com.northpool.service.config.vector_service.storage.IStorageInfo;
import com.northpool.service.config.vector_service.storage.StorageInfoBean;
import com.northpool.service.config.vector_service.storage.StorageInfoShell;
import com.northpool.service.config.vector_service.utfgrid.IUtfgridInfo;
import com.northpool.service.config.vector_service.utfgrid.UtfgridInfoBean;
import com.northpool.service.config.vector_service.utfgrid.UtfgridInfoShell;
import com.northpool.spatial.Constants.LAYER_TYPE;
import com.northpool.spatial.grid.Grid;
import com.northpool.spatial.grid.GridManager;
import com.northpool.spatial.grid.QuadtreeGrid;

public class VectorServiceShell implements IVectorService {
	
	protected Client client;
	
	protected VectorServiceBean vectorService;
	
	protected Map<String,ILayer> layerMap;
	
	protected ICacheable cacheInfo;

	protected IStorageInfo storageInfo;

	protected IUtfgridInfo utfgridInfo;
	
	public VectorServiceShell(Client client,VectorServiceBean vectorService){
		this.client = client;
		this.vectorService = vectorService;
		this.layerMap = this.createLayerMap(client, this.vectorService.dataSetMap, this.vectorService.layerMap);
		this.cacheInfo = this.createCacheInfo(client,vectorService.getCacheInfo());
		this.storageInfo = this.createStorage(vectorService.getStorageInfo());
		this.utfgridInfo = this.createUtfgridInfo(vectorService.getUtfgridInfo());
	}

	private IUtfgridInfo createUtfgridInfo(UtfgridInfoBean utfgridInfo) {
		if (utfgridInfo == null){
			return null;
		}else {
			IUtfgridInfo iUtfgridInfo = new UtfgridInfoShell(this.client, utfgridInfo);
			return iUtfgridInfo;
		}
	}


	protected ICacheable createCacheInfo(Client client, CacheInfoBean cacheInfo){
		if(cacheInfo == null){
			return null;
		}else{
			ICacheable cacheShell = new CacheInfoShell(client, cacheInfo);
			return cacheShell;
		}
	}
	
	protected Map<String,ILayer> createLayerMap(Client client,Map<String, DataSetBean> dataSetMap,Map<String, LayerBean> layerBeanMap){
		Map<String,ILayer> layerMap = layerBeanMap.entrySet().stream().map( entry -> {
			LayerShell layerShell = new LayerShell(client, entry.getValue(),dataSetMap);
			return layerShell;
		}).collect(Collectors.toMap(LayerShell :: getId, layerShell -> layerShell));
		return layerMap;
	}

	private IStorageInfo createStorage(StorageInfoBean storage){
		if (storage != null){
			return new StorageInfoShell(this.client, storage);
		}
		return null;
	}


	@Override
	public void addStorageInfo(IStorageInfo storageInfo) {
		this.storageInfo = storageInfo;
		if(storageInfo == null) {
			this.getBean().setStorageInfo(null);
		}else {
			this.getBean().setStorageInfo(storageInfo.getBean());
		}
	}

	@Override
	public void addUtfgridInfo(IUtfgridInfo utfgridInfo) {
		this.utfgridInfo = utfgridInfo;
		if(utfgridInfo == null) {
			this.getBean().setUtfgridInfo(null);
		}else{
			this.getBean().setUtfgridInfo(utfgridInfo.getBean());
		}
	}


	@Override
	public void addCacheInfo(ICacheable cacheInfo) {
		this.cacheInfo = cacheInfo;
		this.getBean().setCacheInfo(cacheInfo.getCacheInfoBean());
	}

	@Override
	public SERVICE_TYPE getServiceType() {
		// TODO Auto-generated method stub
		return this.vectorService.serviceType;
	}

	@Override
	public String toJson() {
		return JSON.toJSON(this.vectorService).toString();
	}

	@Override
	public String mark() {
		// TODO Auto-generated method stub
		return this.vectorService.id;
	}

	@Override
	public void start() {
		// TODO Auto-generated method stub
		this.vectorService.state = STATE_TYPE.run;
	}

	@Override
	public void stop() {
		// TODO Auto-generated method stub
		this.vectorService.state = STATE_TYPE.stop;
	}

	@Override
	public String state() {
		// TODO Auto-generated method stub
		return this.vectorService.state.name();
		
	}

	@Override
	public STATE_TYPE getState() {
		// TODO Auto-generated method stub
		return this.vectorService.state;
	}

	@Override
	public void rollback(STATE_TYPE state) {
		// TODO Auto-generated method stub
		this.vectorService.state = state;
	}

	@Override
	public boolean needDataCache() {
		// TODO Auto-generated method stub
		if(this.cacheInfo == null){
			return false;
		}else{
			return this.cacheInfo.needDataCache();
		}
	}

	@Override
	public boolean needImgCache() {
		// TODO Auto-generated method stub
		if(this.cacheInfo == null){
			return false;
		}else{
			return this.cacheInfo.needImgCache();
		}
	}

	@Override
	public String getImgScript() {
		// TODO Auto-generated method stub
		if(this.cacheInfo == null){
			return null;
		}else{
			return this.cacheInfo.getImgScript();
		}
	}

	

	@Override
	public String getId() {
		// TODO Auto-generated method stub
		return this.vectorService.id;
	}

	@Override
	public String getName() {
		// TODO Auto-generated method stub
		return this.vectorService.name;
	}

	@Override
	public String getVersion() {
		// TODO Auto-generated method stub
		return this.vectorService.version;
	}

	@Override
	public void setVersion(String version) {
		this.vectorService.setVersion(version);
	}

	@Override
	public Grid getGridTree() {
		// TODO Auto-generated method stub
		QuadtreeGrid quadtreeGrid = GridManager.getQuadtreeGrid(this.vectorService.getGridTreeName(), this.vectorService.getOrigin(), this.vectorService.getResolutions());
		if(quadtreeGrid == null){
			throw new RuntimeException("没有找到格网为" + this.vectorService.gridTreeName);
		}
		return quadtreeGrid;
	}

	//@Override
	/*public VECTOR_SERVICE_LEVEL getLevel() {
		// TODO Auto-generated method stub
		return null;
	}*/

	@Override
	public String getBbox() {
		// TODO Auto-generated method stub
		return this.vectorService.bbox;
	}

	@Override
	public Integer getBeginLevel() {
		// TODO Auto-generated method stub
		return this.vectorService.beginLevel;
	}

	@Override
	public Integer getEndLevel() {
		// TODO Auto-generated method stub
		return this.vectorService.endLevel;
	}

	@Override
	public Map<String, ILayer> getLayerMap() {
		// TODO Auto-generated method stub
		return this.layerMap;
	}

	@Override
	public Boolean isSinglelayer() {
		// TODO Auto-generated method stub
		return this.layerMap.entrySet().size() == 1;
	}

	@Override
	public IDataSourceInService getDataCacheSource() {
		// TODO Auto-generated method stub
		if(this.cacheInfo == null){
			return null;
		}else{
			return this.cacheInfo.getDataCacheSource();
		}
	}

	@Override
	public IDataSourceInService getImgCacheSource() {
		// TODO Auto-generated method stub
		if(this.cacheInfo == null){
			return null;
		}else{
			return this.cacheInfo.getImgCacheSource();
		}
	}

	@Override
	public Boolean allowCache() {
		// TODO Auto-generated method stub
		if(this.cacheInfo == null){
			return false;
		}else{
			return true;
		}
	}

	@Override
	public VectorServiceBean getBean() {
		return this.vectorService;
	}

	@Override
	public String getDataScript() {
		// TODO Auto-generated method stub
		if(this.cacheInfo == null){
			return null;
		}else{
			return this.cacheInfo.getDataScript();
		}
	}

	public void refresh(){
		List<IDataService> dataServices = this.getLayerMap().values().stream()
				.flatMap(layer -> layer.getLevelMap().values().stream())
				.map(layerlevel -> layerlevel.getDataSet().getDataService()).collect(Collectors.toList());
		dataServices.forEach(dataService -> dataService.refresh());
	}


	@Override
	public List<FieldsConfig> getLayerFields(ILayer layer){
        if(!layer.getLayerType().equals(LAYER_TYPE.VECTOR)) {
            return null;
        }
		ILayerLevel layerLevel = layer.getLevelMap().values().iterator().next();
		IDataSet dataSet = layerLevel.getDataSet();
		IDataService dataService = dataSet.getDataService();

		return dataService.getFields();
	}

	@Override
	public String getLayerIdFieldName(ILayer layer){
        if(!layer.getLayerType().equals(LAYER_TYPE.VECTOR)) {
            return null;
        }
        ILayerLevel layerLevel = layer.getLevelMap().values().iterator().next();
		IDataSet dataSet = layerLevel.getDataSet();
        IDataService dataService = dataSet.getDataService();

        return dataService.getIdFieldName();
	}

	public String getLayerIdFieldType(ILayer layer){
        if(!layer.getLayerType().equals(LAYER_TYPE.VECTOR)) {
            return null;
        }
        ILayerLevel layerLevel = layer.getLevelMap().values().iterator().next();
		IDataSet dataSet = layerLevel.getDataSet();
		IDataService dataService = dataSet.getDataService();
		return dataService.getIdField().getType();
	}



	@Override
	public String getLayerGeometryType(ILayer layer){
        if(!layer.getLayerType().equals(LAYER_TYPE.VECTOR)) {
            return null;
        }
        ILayerLevel layerLevel = layer.getLevelMap().values().iterator().next();
		IDataSet dataSet = layerLevel.getDataSet();
		IDataService dataService = dataSet.getDataService();
		return dataService.getGeoType().name();
	}

	@Override
	public int[] getOrigin() {
		return this.vectorService.getOrigin();
	}

	@Override
	public double[] getResolutions() {
		return this.vectorService.getResolutions();
	}

	@Override
	public List<String> getDataServiceIds() {
		return this.getBean().getDataSetMap().values().stream().map(dataSetBean -> dataSetBean.getDataServiceId()).collect(Collectors.toList());
	}

	public ICacheable getCacheInfo() {
		return cacheInfo;
	}

	@Override
	public CacheInfoBean getCacheInfoBean() {
		return cacheInfo.getCacheInfoBean();
	}

	@Override
	public void drop(String serverName, String styleId) {

	}

	public void setCacheInfo(ICacheable cacheInfo) {
		this.cacheInfo = cacheInfo;
	}

	public IStorageInfo getStorageInfo() {
		return storageInfo;
	}

	public void setStorageInfo(IStorageInfo storageInfo) {
		this.storageInfo = storageInfo;
	}

	public IUtfgridInfo getUtfgridInfo() {
		return utfgridInfo;
	}

	public void setUtfgridInfo(IUtfgridInfo utfgridInfo) {
		this.utfgridInfo = utfgridInfo;
	}

	@Override
	public Document toDocument() {
		return Document.parse(this.toJson());
	}

	@Override
	public Client getClient(){
		return this.client;
	}
}
