package com.northpool.service.config.vector_service.layer;

import com.northpool.resources.command.QueryFilter;
import com.northpool.resources.inmemoryold.IArrayFilter;
import com.northpool.resources.inmemoryold.QueryFilterToInMemory;
import com.northpool.service.client.Client;
import com.northpool.service.config.vector_service.dataset.DataSetBean;
import com.northpool.service.config.vector_service.dataset.DataSetShell;
import com.northpool.service.config.vector_service.dataset.IDataSet;

import java.util.Arrays;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;

public class LayerLevelShell implements ILayerLevel {

	protected LayerLevelBean layerLevel;
	
	protected Client client;
	
	protected IArrayFilter arrayFilter;
	
	protected IDataSet dataSet;
	
	protected ISimplify[] simplifyArray;
	
	public LayerLevelShell(Client client,LayerLevelBean layerLevel,Map<String,DataSetBean> dataSetHashMap) throws Exception{
		this.client = client;
		this.layerLevel = layerLevel;
		String filterSQL = layerLevel.getFilterSQL();
		//创建过滤条件
		this.arrayFilter = this.createArrayFilter(filterSQL);
		//创建IDataSet
		DataSetBean dataSet = dataSetHashMap.get(this.layerLevel.dataSetId);
		if(dataSet == null){
			throw new RuntimeException(String.format("没有找到dataset%s", this.layerLevel.dataSetId));
		}
		this.dataSet = this.createDataSet(client,dataSet);
		//创建ISimplify
		this.simplifyArray = this.createISimplifyArr();
	}
	
	protected ISimplify[] createISimplifyArr(){
		if(this.layerLevel.getSimplifyArr() == null){
			return null;
		}
		return Arrays.asList(this.layerLevel.getSimplifyArr()).stream().map( simplify->{
			try {
				return new SimplifyShell(simplify);
			} catch (Exception e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
				throw new RuntimeException(e);
			}
		}).toArray(ISimplify[]::new);
	
	}
	
	
	protected IDataSet createDataSet(Client client,DataSetBean dataSet){
		return new DataSetShell(client,dataSet);
	}
	
	
	protected IArrayFilter createArrayFilter(String filterSQL) throws Exception{	
		IArrayFilter arrayFilter = null;
		if(StringUtils.isNotBlank(filterSQL)) {
			try{
				QueryFilter queryFilter = new QueryFilter();
				queryFilter.addSQL(filterSQL);
				arrayFilter = new QueryFilterToInMemory(queryFilter).toArrayFilter();
			}catch(Exception e){
				e.printStackTrace();
				throw new Exception("层级:" + layerLevel.level +" 过滤条件:" + filterSQL + "解析出错");
			}
		}
		return arrayFilter;
	}
	
	public Double getSimplifyForLayerLevel() {
		// TODO Auto-generated method stub
		return this.layerLevel.simplifyForLayerLevel;
	}

	

	@Override
	public Double getSimplify(String[] attrNames, Object[] values) {
		// TODO Auto-generated method stub
		return this.getSimplify(attrNames, values);
	}

	@Override
	public Boolean isFeatureSave(String[] attrNames, Object[] values) throws Exception {
		// TODO Auto-generated method stub
		if (this.arrayFilter == null){
			return true;
		}
		return this.arrayFilter.isSave(attrNames, values);
	}

	@Override
	public String getFilterExpression() {
		// TODO Auto-generated method stub
		return this.layerLevel.getFilterSQL();
	}

	@Override
	public void setFilterExpression(String filterExpression) throws Exception {
		this.layerLevel.setFilterSQL(filterExpression);
		this.arrayFilter = this.createArrayFilter(filterExpression);

	}

	@Override
	public Integer getLevel() {
		// TODO Auto-generated method stub
		return this.layerLevel.getLevel();
	}

	@Override
	public IArrayFilter getFilter() {
		// TODO Auto-generated method stub
		return this.arrayFilter;
	}

	@Override
	public Boolean isVirtual() {
		// TODO Auto-generated method stub
		return this.layerLevel.virtual;
	}

	@Override
	public IDataSet getDataSet() {
		// TODO Auto-generated method stub
		return this.dataSet ;
	}

	@Override
	public Integer getLineCutBase() {
		return layerLevel.getLineCutBase();
	}

	@Override
	public Integer getMinCutPixel() {
		return layerLevel.getMinCutPixel();
	}

	@Override
	public Integer getMinCutPoint() {
		return layerLevel.getMinCutPoint();
	}

	@Override
	public ISimplify[] getSimplifyArr() {
		// TODO Auto-generated method stub
		return this.simplifyArray;
	}


	public static void main(String[] args) throws Exception {
		String filterSQL = "1 = 2";
		IArrayFilter arrayFilter = null;
		if(filterSQL != null){
			if(!"".equalsIgnoreCase(filterSQL)){
				try{
					QueryFilter queryFilter = new QueryFilter();
					queryFilter.addSQL(filterSQL);
					arrayFilter = new QueryFilterToInMemory(queryFilter).toArrayFilter();
				}catch(Exception e){
					e.printStackTrace();
				}
			}
		}
		boolean issave = arrayFilter.isSave(new String[]{"11"}, new String[]{"name"});
		System.out.println(issave);
/*		String f = "fcode not in ('4206000313')";
		String filterSQL = "( fscale  <= 15 and display in  ('4302000414','4303000313') ) OR ( fscale  <= 15 and display  in  ('4202010413','4200010313','4201010413','4202020413','4200020313') ) OR ( fscale  <= 15 and display in  ('4201010313','4201020313') ) OR ( fscale  <= 15 and display  in  ('4202010313','4202020313') ) OR ( fscale  <= 15 and display  in  ('4203010313','4203020313') ) OR ( fscale  <= 15 and display  in  ('4204010313','4204000313') ) OR ( fscale  <= 15 and display  =  '4305010313' ) OR ( fscale  <= 15 and display = '4305020313' ) OR ( fscale  <= 15 and not  ( fname  is  null )   and  display  not  in  ('4302000414','4303000313','4202010413','4200010313','4200020313','4201010413','4202020413','4201010313','4201020313','4202010313','4202020313','4203010313','4203020313','4204010313','4204000313','4305010313','4305020313') ) OR ( display  in  ('4303000313') ) OR ( display  in  ('4302000414') ) OR ( display =  '4206000313' ) OR ( display  in  ('4202010413','4200010313','4201010413') ) OR ( display  in  ('4200020313','4202020413') ) OR ( display = '4201010313' ) OR ( display = '4201020313' ) OR ( display = '4202010313' ) OR ( display = '4202020313' ) OR ( display = '4305010313' ) OR ( display = '4305020313' ) OR ( display = '4203010313' ) OR ( display = '4203020313' ) OR ( display = '4204000313' ) OR ( display = '4204010313' ) OR ( display = '4305030313' ) OR ( display = '4305040313' ) OR ( display = '4205000313' ) OR ( display = '4205010313' ) OR ( display = '4209000313' ) OR ( display = '4209010313' ) OR ( display = '4208000313' ) OR ( display = '4208010313' ) OR ( display = '4406000314' ) OR ( display = '4306000313' ) OR ( display in  ('4401000313','4401000311','4402000313','4402000314','4403000314') )";
		IArrayFilter arrayFilter = null;
		QueryFilter queryFilter = new QueryFilter();
		queryFilter.addSQL(filterSQL);
		arrayFilter = new QueryFilterToInMemory(queryFilter).toArrayFilter();*/
	}
}
