package com.northpool.service.config.vector_service.layer;

import com.northpool.service.client.Client;
import com.northpool.service.config.vector_service.dataset.DataSetBean;
import com.northpool.spatial.Constants.LAYER_TYPE;

import java.util.Map;
import java.util.stream.Collectors;

public class LayerShell implements ILayer {

	protected LayerBean layer;
	
	protected Client client;
	
	protected Map<String,DataSetBean> dataSetHashMap;
	
	protected Map<Integer, ILayerLevel> layerLevelMap;	
	
	public LayerShell(Client client,LayerBean layer,Map<String, DataSetBean> map){
		this.client = client;
		this.layer = layer;
		this.dataSetHashMap = map;
		this.layerLevelMap = this.createLayerLevelMap(this.layer.levelMap);
		
	}
	
	protected Map<Integer, ILayerLevel> createLayerLevelMap(Map<Integer, LayerLevelBean> levelMap){
		return levelMap.entrySet().stream().map( entry -> {
			LayerLevelBean layerLevel = entry.getValue();
			LayerLevelShell layerLevelShell;
			try {
				layerLevelShell = new LayerLevelShell( this.client, layerLevel, this.dataSetHashMap);
			} catch (Exception e) {
				// TODO Auto-generated catch block
				throw new RuntimeException(e);
			}
			return layerLevelShell;
		}).collect(Collectors.toMap(LayerLevelShell::getLevel, layerLevelShell->layerLevelShell));
	}
	
	@Override
	public String getId() {
		// TODO Auto-generated method stub
		return layer.getId();
	}

	@Override
	public Integer getBeginLevel() {
		// TODO Auto-generated method stub
		return layer.getBeginLevel();
	}

	@Override
	public Integer getEndLevel() {
		// TODO Auto-generated method stub
		return layer.getEndLevel();
	}
	
	@Override
	public Map<Integer, ILayerLevel> getLevelMap() {
		// TODO Auto-generated method stub
		return this.layerLevelMap;
	}

	@Override
	public boolean isHaveLabel() {
		// TODO Auto-generated method stub
		return this.layer.haveLabel;
	}

	@Override
	public Label getLabel() {
		// TODO Auto-generated method stub
		return this.layer.label;
	}

	@Override
	public Boolean getLabelOnly() {
		// TODO Auto-generated method stub
		return this.layer.labelOnly;
	}

	@Override
	public Boolean getCutOutScreen() {
		// TODO Auto-generated method stub
		return layer.getCutOutScreen();
	}

	@Override
	public LayerBean getBean() {
		return this.layer;
	}

    @Override
    public LAYER_TYPE getLayerType() {
        return this.layer.getLayerType();
    }

}
