package com.northpool.service.config.vector_service.layer;

import com.northpool.resources.command.QueryFilter;
import com.northpool.resources.inmemoryold.IArrayFilter;
import com.northpool.resources.inmemoryold.QueryFilterToInMemory;

public class SimplifyShell implements ISimplify {
	
	protected SimplifyBean simplify;
	
	protected IArrayFilter simplifyFilter;
	
	public SimplifyShell(SimplifyBean simplify) throws Exception{
		this.simplify = simplify;
		String filterSQL = simplify.filterSQL;
		if(filterSQL != null){
			if(!"".equalsIgnoreCase(filterSQL)){
				try{
					QueryFilter queryFilter = new QueryFilter();
					queryFilter.addSQL(filterSQL);
					this.simplifyFilter = new QueryFilterToInMemory(queryFilter).toArrayFilter();
				}catch(Exception e){
					e.printStackTrace();
					throw new Exception("抽稀 过滤条件:" + filterSQL + "解析出错");
				}
			}
		}
	}
	
	



	@Override
	public IArrayFilter getFilter() {
		// TODO Auto-generated method stub
		return this.simplifyFilter;
	}



	@Override
	public String getFilterExpressionFilter() {
		// TODO Auto-generated method stub
		return this.simplify.filterSQL;
	}



	@Override
	public Double getSimplify() {
		// TODO Auto-generated method stub
		return this.simplify.simplify;
	}
}
