package com.northpool.service.dao;

import com.northpool.bean.Idable;
import com.northpool.bean.Jsonable;
import com.northpool.bean.JsonableBuilder;
import com.northpool.service.client.Client;
import com.northpool.service.config.CanStartStop;
import com.northpool.service.config.IDocumentAble;
import com.northpool.structure.queryhashtable.QueryHashTableHeap;
import org.apache.curator.framework.api.transaction.CuratorOp;
import org.apache.curator.framework.api.transaction.TransactionOp;

import java.util.List;

public class AbtractServiceZkDao<T extends Jsonable & Idable<String> & IDocumentAble & CanStartStop,Builder extends JsonableBuilder<T>> extends AbstractZkDao<T,Builder> {

    protected static final String STATS_TYPE_NAME = "stats";

    public AbtractServiceZkDao(String idFieldName, Builder beanBuilder, QueryHashTableHeap<String, T> table, Client client, String managerRoot, Boolean readOnly) {
        super(idFieldName, beanBuilder, table, client, managerRoot, readOnly);
    }

    @Override
    protected void AddExtendsInfo2BeanNode(String path, List<CuratorOp> iList, TransactionOp transaction, T t) throws Exception {
        // TODO Auto-generated method stub
        CuratorOp createOp = transaction.create().forPath(path + "/" + STATS_TYPE_NAME,t.state().getBytes());
        iList.add(createOp);
    }

}
