package com.northpool.service.dao.style;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.northpool.service.client.Client;
import com.northpool.service.config.style.IStyleService;
import com.northpool.service.config.style.StyleBuilder;
import com.northpool.service.dao.AbstractZkDao;
import com.northpool.service.manager.IMetaDataManager;
import com.northpool.structure.queryhashtable.QueryHashTableHeap;
import org.apache.curator.framework.api.transaction.CuratorOp;
import org.apache.curator.framework.api.transaction.TransactionOp;
import org.apache.zookeeper.CreateMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.List;

public class StyleZkDao extends AbstractZkDao<IStyleService, StyleBuilder> {

    Logger logger = LoggerFactory.getLogger(StyleZkDao.class);

    public StyleZkDao(String idFieldName, StyleBuilder beanBuilder, QueryHashTableHeap<String, IStyleService> table, Client client, String managerRoot, Boolean readOnly, IMetaDataManager<IStyleService> manager) {
        super(idFieldName, beanBuilder, table, client, managerRoot, readOnly);
        this.manager = manager;
        this.mongoDao = new StyleMongoDao(client.initMongoClient(),  this.idFieldName, beanBuilder);
    }

    protected List<CuratorOp> createBeanNode(TransactionOp transaction, IStyleService t) throws Exception{
        String id = t.getId();
        String path = this.path(id);
        List<CuratorOp> iList = new ArrayList<CuratorOp>();
        CuratorOp createOp1 = transaction.create().withMode(CreateMode.PERSISTENT).forPath(path,id.getBytes("utf-8"));
        iList.add(createOp1);
        CuratorOp createOp2 = transaction.create().forPath(path + "/id",t.getId().getBytes("utf-8"));
        iList.add(createOp2);
        JSONObject obj = (JSONObject) JSON.toJSON(t.getBean());//去掉体积较大的字段，免得zk放不下
        obj.remove("styleJson");
        obj.remove("styleLayerJs");
        obj.remove("styleLabelJs");
        obj.remove("styleAvoidjs");
        obj.remove("queryLayer");
        obj.remove("queryLabel");
        obj.remove("mapboxStyle");
        CuratorOp createOp3 = transaction.create().forPath(path + "/data",obj.toJSONString().getBytes("utf-8"));
        iList.add(createOp3);
        this.AddExtendsInfo2BeanNode(path, iList, transaction, t);
        return iList;
    }

    public void insert(IStyleService styleService) throws Exception{
        if (this.mongoDao.findone(styleService.getId()) == null) {
            this.mongoDao.insertOne(styleService);
        }
        TransactionOp transaction = client.getZoo().transactionOp();
        List<CuratorOp> iList = this.createBeanNode(transaction, styleService);
        client.getZoo().transaction().forOperations(iList);
    }

    public void update(IStyleService styleService) throws Exception {
        TransactionOp transaction = client.getZoo().transactionOp();
        List<CuratorOp> iListUpdate = new ArrayList<CuratorOp>();
        List<CuratorOp> iListDelete = this.deleteBeanNode(transaction, styleService.getId());
        iListUpdate.addAll(iListDelete);
        List<CuratorOp> iListAdd = this.createBeanNode(transaction, styleService);
        iListUpdate.addAll(iListAdd);
        client.getZoo().transaction().forOperations(iListUpdate);
    }

    @Override
    protected void AddExtendsInfo2BeanNode(String path, List<CuratorOp> iList, TransactionOp transaction, IStyleService iStyleService) throws Exception {

    }
}
