package com.northpool.service.manager.task;


import com.northpool.service.manager.task.log.ITaskLogger;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;

public interface ITileDispatchTask {

    public void init();

    public void start() throws Exception;

    public void cancel();

    public void pause();

    public void error();

    public void success() throws Exception;

    public void setExecutor(ExecutorService executor);

    public void setLogger(ITaskLogger cutLogger);

    public void setLogPool(ScheduledExecutorService logPool);

    public void onSuccess(ITaskCallback onsuccess);

    public void onError(ITaskCallback onerror);

    public void onStart(ITaskCallback onStart);

    public boolean isError();

    void onCancel(ITaskCallback onCancel);

    void onPause(ITaskCallback onPause);

    public boolean isSuccess();
}
