/**
　 * <p>Title: TerrainServiceManager.java</p>
　 * <p>Description: </p>
　 * <p>Copyright: Copyright (c) 2021</p>
　 * <p>Company: northpool</p>
　 * @author chy
　 * @date 2021年12月22日
　 * @version 1.0
*//*

package com.northpool.service.manager.terrain_service;

import java.util.Objects;

import org.apache.commons.lang3.StringUtils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.northpool.service.config.raster_service.IRasterService;
import com.northpool.service.config.raster_service.layer.IRasterLayer;
import com.northpool.service.config.terrain_service.TerrainServiceBuilder;
import com.northpool.service.config.vector_service.ICacheable;
import com.northpool.service.config.vector_service.storage.IStorageInfo;
import com.northpool.service.dao.terrian_service.TerrainServiceMongoDao;
import com.northpool.service.dao.terrian_service.TerrainServiceZkDao;
import com.northpool.service.manager.abstractclass.ServiceManager;
import com.northpool.service.manager.abstractclass.ZKException;

*/
/**
 * @author chy
 *
 *//*

public class TerrainServiceManager extends ServiceManager<IRasterService, TerrainServiceBuilder> implements ITerrainServiceManager {
    
    protected static final String MANAGER_ROOT = "terrain_service";

    protected static final String MONGO_COLLECTION_NAME = "TAB_MAPENGINE_SERVER_INFO";

    public TerrainServiceManager() {
        super("id", new TerrainServiceBuilder(), MANAGER_ROOT);
    }

    public void init(){
        super.init();
        this.beanBuilder.setClient(client);
        this.mongoDao = new TerrainServiceMongoDao(client.initMongoClient(), MONGO_COLLECTION_NAME, "id", beanBuilder);
        if (client.getZoo() != null){
            this.zkDao = new TerrainServiceZkDao(idFieldName, beanBuilder, table, client, managerRoot, readOnly, this);
            this.zkDao.init();
            try {
                this.zkDao.syncFromZK();
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
    
    @Override
    public void register(IRasterService imageService) throws ZKException {
        this.checkInvalid(imageService);
        
        super.doAdd(imageService);
        
    }
    */
/**
     * 后续补充
     * @param imageService
     *//*

    protected void checkInvalid(IRasterService imageService) {
        
    }

    public IRasterService get(String id) {
        IRasterService service = super.get(id);
        return service;
    }
    
    @Override
    public String getJSON(String id) {
        IRasterService vectorService = this.get(id);
        if (vectorService == null){
            return null;
        }

        JSONObject jsonService = (JSONObject)JSON.toJSON(vectorService.getBean());

        this.addFiledsAndStorageToLayers(jsonService, vectorService);

        IStorageInfo storageInfo = vectorService.getStorageInfo();
        if (storageInfo != null){
            this.addStorageInfoToService(jsonService, storageInfo);
        }

        ICacheable cacheInfo = vectorService.getCacheInfo();
        if (cacheInfo != null){
            this.addCacheInfoToService(jsonService, cacheInfo);
        }

        return JSON.toJSONString(jsonService, SerializerFeature.DisableCircularReferenceDetect);
    }
    
    private void addCacheInfoToService(JSONObject jsonService, ICacheable cacheInfo) {
        JSONObject obj = new JSONObject();
        obj.put("dataCacheSource", cacheInfo.getDataCacheSource().getBean());
        obj.put("imgCacheSource", cacheInfo.getImgCacheSource().getBean());
        obj.put("needDataCache", cacheInfo.needDataCache());
        obj.put("needImgCache", cacheInfo.needImgCache());
        obj.put("imgScript", cacheInfo.getImgScript());
        obj.put("dataScript", cacheInfo.getDataScript());
        jsonService.put("cacheInfo", obj);
    }

    private void addStorageInfoToService(JSONObject jsonService, IStorageInfo storageInfo) {
        JSONObject storageJsonObj = (JSONObject) JSON.toJSON(storageInfo.getDataSource().getBean());
        storageJsonObj.put("storageName", storageInfo.getStorageName());
        storageJsonObj.put("startLevel", storageInfo.getStartLevel());
        storageJsonObj.put("endLevel", storageInfo.getEndLevel());
        storageJsonObj.put("completed", storageInfo.isCompleted());
        jsonService.put("storageInfo", storageJsonObj);
    }
    
    private void addFiledsAndStorageToLayers(JSONObject jsonService, IRasterService vectorService) {
        JSONObject layerMap = jsonService.getJSONObject("layerMap");
        layerMap.forEach((layerName, layer) -> {
            String name = layerName;
            IRasterLayer iLayer = vectorService.getLayerMap().get(name);
            JSONObject jsonLayer = (JSONObject) layer;
            IStorageInfo storageInfo = null;
            storageInfo = iLayer.getLevelMap().values().iterator().next().getDataSet().getRasterDataService().getStorageInfo();
            
            if (storageInfo == null){
                return;
            }
            JSONObject storageJsonObj = (JSONObject) JSON.toJSON(storageInfo.getDataSource().getBean());
            storageJsonObj.put("storageName", storageInfo.getStorageName());
            storageJsonObj.put("startLevel", storageInfo.getStartLevel());
            storageJsonObj.put("endLevel", storageInfo.getEndLevel());
            storageJsonObj.put("completed", storageInfo.isCompleted());
            jsonLayer.put("storageInfo", storageJsonObj);
        });
    }
    
    @Override
    public void unRegister(String id) throws ZKException {
        super.doRemove(id);
    }

    @Override
    public void update(IRasterService vectorService) throws ZKException {
        this.checkInvalid(vectorService);
        super.doUpdate(vectorService);
    }

    @Override
    public boolean checkVersion(String id, String version) {
        IRasterService vectorService = this.get(id);
        if(vectorService != null) {
            return Objects.equals(version, vectorService.getVersion());
        }
        return false;
    }

    @Override
    public void rename(String oldName, String newName) throws ZKException {
        IRasterService old = this.get(oldName);
        if(old == null) {
            throw new RuntimeException(StringUtils.join("服务 ", oldName, " 不存在"));
        }

        IRasterService newService = this.get(newName);
        if(newService != null) {
            throw new RuntimeException(StringUtils.join("服务 ", newService, " 已存在"));
        }
        
        IStorageInfo storageInfo = old.getStorageInfo();
        if(storageInfo != null) {
            storageInfo.rename(newName);
            storageInfo.renameLabel(newName);
        }

        this.unRegister(oldName);
        old.getBean().setId(newName);
        this.register(old);
    }
    
    */
/**
     * 级联删除服务相关资源
     * @param id 服务ID
     * @throws Exception 
     *//*

    public void unRegisterCascade(String id) throws Exception {

        IRasterService service = this.get(id);
        
        IStorageInfo storageInfo = service.getStorageInfo();
        if (storageInfo != null){
            storageInfo.drop();
        }
        
        this.unRegister(id);
    }
}
*/
