package com.northpool.commons.classloader;


import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map.Entry;





public class MemoryClassLoader extends ClassLoader {


	protected HashMap<String,MemoryJar> jarMap = new HashMap<String,MemoryJar>();
	
	//protected ArrayList<String> jarNameArr = new ArrayList<String>();
	
	protected HashMap<String,ByteBuffer> resourceMap = new HashMap<String,ByteBuffer>();
	
	//protected HashMap<String,String> classMap = new HashMap<String,String>();
	
	//protected ArrayList<String> urlArray = new ArrayList<String>();

	public MemoryClassLoader(){
	    super();
	    this.init();
	}

	public void init(){
		
		try {

			Field f = ClassLoader.class.getDeclaredField("parent");
			f.setAccessible(true);
			ClassLoader parent = (ClassLoader) f.get(this);
			ClassLoader parentparent = (ClassLoader) f.get(parent);
			InnerClassLoader l = new InnerClassLoader(new URL[0],parentparent,this);
			f.set(parent,l);

		} catch (NoSuchFieldException | SecurityException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IllegalArgumentException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IllegalAccessException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

	public MemoryClassLoader(ClassLoader parent){
		super(parent);
	}
	
	private static enum TYPE{
		classPath,urlPath
	}
	
	/*protected MemoryJar getJar(String jarName){
		for(MemoryJar jar : this.jarMap.values()){
			if(jar.getName().equals(jarName)){
				return jar;
			}
		}
		return null;
	}*/
	
	protected TYPE isType(String path){
		if(path.indexOf(":") != -1){
			return TYPE.urlPath;
		}else{
			return TYPE.classPath;
		}
	}
	
	protected byte[] findClassByte(String uri) throws IOException {
	    
	    ByteBuffer buffer = this.resourceMap.get(uri);
	    if(buffer == null){
            return null;
        }
        return getBytes(buffer);
		/*String jarName = uri.split("!")[0].replace("jar:file:$memory", "").substring(1);
		String className = uri.split("!")[1].substring(1);
		MemoryJar memoryJar = this.getJar(jarName);
		if(memoryJar == null){
			return null;
		}else{
			ByteBuffer buffer = memoryJar.getClass(className);
			if(buffer == null){
			    return null;
			}
			return buffer.array();
		}*/
	}
	
	private byte[] getBytes(ByteBuffer buffer){
	    buffer.flip();
	    int length = buffer.limit() - buffer.position();
	    byte[] bytes = new byte[length];
	    buffer.get(bytes);
	    return bytes;
	}
	
	protected InputStream findClassInputStream(String uri) throws IOException{
		byte[] b = this.findClassByte(uri);
		if(b == null){
			return null;
		}else{
			return 	new ByteArrayInputStream(b);
		}
	}
	
	

	
	public InputStream getClassAsStream(String url){
		
	//	TYPE type = this.isType(url);
		
		//if(type == TYPE.urlPath){
		if(this.resourceMap.get(url) != null){	
			InputStream is;
			try {
				is = this.findClassInputStream(url);
				return is;
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
				return null;
			}
		} 
		return null;
	/*	}else{
			String urlPath = this.classMap.get(url);
			if(urlPath == null){
				return null;
			}
			InputStream is;
			try {
				is = this.findClassInputStream(urlPath);
				return is;
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
				return null;
			}
		}
		return null;*/
	}
	
	public synchronized void loadJar(String jarName,byte[] jarByte) throws IOException{
		if(this.jarMap.containsKey(jarName)){
		    throw new RuntimeException("已经注册过jar:" + jarName);
		}
		MemoryJar memoryJar = new MemoryJar(jarName,jarByte);
		HashMap<String,ByteBuffer> jarClassMap = memoryJar.getAllResources();
		Iterator<Entry<String,ByteBuffer>> iterator = jarClassMap.entrySet().iterator();
		while(iterator.hasNext()){
		    Entry<String,ByteBuffer> entry = iterator.next();
		  //  System.out.println("key=" + entry.get);
		}
		
		this.resourceMap.putAll(memoryJar.getAllResources());
	//	this.jarMap.put(memoryJar.getName(), memoryJar);
	
	}
	
	
	
	
	/*public List<String> getAllResources(String memoryUrl){
		String jarName = memoryUrl.replace("file:$memory", "").substring(1);
		for(MemoryJar jar : jarArr){
			if(jar.getName().equals(jarName)){
				return jar.getAllResources();
			}
		}
		return new ArrayList<String>();
	}*/

	private Class<?> findClassInMemory(String className) throws ClassNotFoundException{
	    String mark_name = className.replace(".", "/");
        
	    Class<?> clazz = this.findClass(className);
	    if(clazz != null){
	        return clazz;
	    }
	    
        mark_name = new StringBuilder().append(mark_name).append(".class").toString();
        
        byte[] classByte = null;
        
        try {
            classByte = this.findClassByte(mark_name);
        } catch (IOException e) {
            throw new ClassNotFoundException(className);
        }
        if(classByte == null){
            return null;
        }
        
        Class<?> c = defineClass(className, classByte, 0, classByte.length);
        
        return c;
	}
	
	
	public Class<?> findLoadedClassByName(String name){
		return findLoadedClass(name);
	}
	
	
	protected Class<?> loadClass(String name, boolean resolve)
	        throws ClassNotFoundException{
	    synchronized (getClassLoadingLock(name)) {
	        Class<?> clazz = this.findClass(name);
	        if(clazz == null){
	            return this.getParent().loadClass(name);
	        }else{
	            return clazz;
	        }
	    }
	}
	
	
	@Override
	protected Class<?> findClass(String name) throws ClassNotFoundException {
	
		Class<?> c = findLoadedClass(name);
		
		
		if (c != null) {
			return c;
		}
		String mark_name = name.replace(".", "/");
		
		mark_name = new StringBuilder().append(mark_name).append(".class").toString();
		
	/*	String uri = this.resourceMap.get(mark_name);
		
		if(uri == null){
			throw new ClassNotFoundException(name);
		}*/
		
		byte[] classByte = null;
		
		try {
			classByte = this.findClassByte(mark_name);
		} catch (IOException e) {
			throw new ClassNotFoundException(name);
		}

		if(classByte == null){
		    return null;
		}
		
		c = defineClass(name, classByte, 0, classByte.length);
		
		return c;
	}


	@Override
	protected URL findResource(String name) {
//		ArrayList<URL> resourcesList = new ArrayList<URL>();
//
//		this.jarArr.stream().forEach( jar ->{
//			try {
//				resourcesList.addAll(jar.findResources(name));
//			} catch (IOException e) {
//				// TODO Auto-generated catch block
//				e.printStackTrace();
//				throw new RuntimeException(e);
//			}
//		});
//		if (!resourcesList.isEmpty()){
//			return resourcesList.get(0);
//		}
//		return null;
	    
	    
	    ByteBuffer buffer = this.resourceMap.get(name);
	    if(buffer == null){
	        return null;
	    }else{
	        return this.createURI(name, buffer);
	    }
	}
	
	private URL createURI(String resourceName,ByteBuffer buffer){
	    try{
            
            URL url1 = new URL(null, "memory:" + resourceName, new URLStreamHandler() {
                @Override
                protected URLConnection openConnection(URL u) throws IOException {
                    return new MemoryURLConnection(null, resourceName, buffer);
                }
            });
            return url1;
        } catch (Exception e){
            throw new RuntimeException(e);
        }
	}
	
	/*private String createURIPath(String entryName){
        //urlJar = urlJar.replace("\\", "/");
        String path = "file:$memory" + File.separatorChar + entryName;
        path = path.replace("\\", "/");
        return path;
    }*/
	
	/**
     * 创建资源地址
     * @param jarName
     * @param entryName
     * @return
     */
    static String createURIPath(String entryName){
        //urlJar = urlJar.replace("\\", "/");
        //String path = "jar:file:$memory" + File.separatorChar + jarName + "!" + File.separatorChar + entryName;
        String path = entryName.replace("\\", "/");
        return path;
    }
	
	
	public synchronized void registerClass(String className,byte[] bytes){
	    className = className.replace(".", "/");
	    className = className + ".class";
	    String uri = createURIPath(className);
	    ByteBuffer buff = ByteBuffer.allocateDirect(bytes.length);
	    buff.put(bytes);
	    this.resourceMap.put(uri, buff);
	}


	@Override
	protected Enumeration<URL> findResources(final String name) throws IOException {
	//	this.logger.debug("finding resources:" + name);
		ArrayList<URL> resourcesList = new ArrayList<URL>();
		
		this.resourceMap.entrySet().stream().forEach( entry ->{
		    String resourceName = entry.getKey();
		    ByteBuffer buffer = entry.getValue();
		    if(resourceName.startsWith(name)){
		        
		        resourcesList.add(this.createURI(resourceName, buffer));
		    }
		});
				
		URL[] arr = resourcesList.stream().toArray(URL[] :: new);

		Enumeration<URL> en = new Enumeration<URL>(){
			
			private int current = 0;
			
			@Override
			public boolean hasMoreElements() {
				// TODO Auto-generated method stub
				if(current == arr.length){
					return false;
				}else{
					return true;
				}
			}

			@Override
			public URL nextElement() {
				// TODO Auto-generated method stub
				URL url = arr[current];
				current ++;
				return url;
			}
		};
	    return en;
	}

	class InnerClassLoader extends URLClassLoader{
	    
	    
	   // protected ClassLoader parent;
	//    Logger logger = LoggerFactory.getLogger(InnerClassLoader.class);
	    
	    protected MemoryClassLoader classLoader;
	    
	    protected HashMap<String,ByteBuffer> resourceMap = new HashMap<String,ByteBuffer>();
        /**
         * @param urls
         */
        public InnerClassLoader(URL[] urls,ClassLoader parent,MemoryClassLoader classLoader) {
            super(urls,parent);
            this.classLoader = classLoader;
            // TODO Auto-generated constructor stub
        }
	    
        
        
        @Override
        protected Class<?> findClass(final String name) throws ClassNotFoundException{
       //     logger.debug("InnerClassLoader load " + name);
          //  System.out.println("InnerClassLoader load " + name);
  
            Class<?> c = null;
            c = classLoader.findClassInMemory(name);
            //Class<?> c = classLoader.findClass(name);
            return c;
        }
	}
	
	

}
