package com.northpool.devtool.AbnormalCheck;

import com.northpool.devtool.AbnormalCheck.abstractclass.AbstractCheck;
import com.northpool.devtool.model.CpuInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author Bai Chenguang
 * @Date: 2022/07/26/ 下午 5:22
 * @Description
 */
public class CpuCheck extends AbstractCheck implements IAbnormalCheck{

    Logger log =  LoggerFactory.getLogger(getClass());

    final Integer MIN_CORE = 2;

    static CpuCheck inst;

    public static CpuCheck getInst() {
        if (inst == null) {
            inst = new CpuCheck();
        }
        return inst;
    }

    @Override
    public void check() {
        CpuInfo cpuInfo = new CpuInfo();
        if(cpuInfo.getCoreNum() < MIN_CORE){
            log.error("Cpu 核心数小于允许的最小数目 {}, 请分配合理的硬件资源", MIN_CORE);
            log.error("1.增加 Cpu 核心数后再启动");
            this.shutdown();
        }
    }
}
