package com.northpool.devtool.AbnormalCheck;

import com.northpool.devtool.AbnormalCheck.abstractclass.AbstractCheck;
import com.northpool.devtool.model.JvmInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author Bai Chenguang
 * @Date: 2022/06/23/ 下午 8:03
 * @Description
 */
public class JvmCheck extends AbstractCheck implements IAbnormalCheck {
    private static Logger logger = LoggerFactory.getLogger(JvmCheck.class);
    JvmInfo jvmInfo = new JvmInfo();
    static JvmCheck inst;

    public static JvmCheck getInst() {
        if (inst == null) {
            inst = new JvmCheck();
        }
        return inst;
    }

    @Override
    public void check() {
        String version = jvmInfo.getVersion();
        if (!version.startsWith("1.8")) {
            logger.error("只允许使用 jdk/jre 1.8版本,当前使用版本: {}", version);
            this.shutdown();
        }
        super.check();
    }
}
