package com.northpool.devtool.AbnormalCheck;

import com.mongodb.MongoSecurityException;
import com.mongodb.MongoSocketOpenException;
import com.mongodb.MongoTimeoutException;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.northpool.devtool.AbnormalCheck.abstractclass.AbstractCheck;
import com.northpool.devtool.model.MongoDbInfo;
import com.northpool.resources.utils.MongoClientURI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author Bai Chenguang
 * @Date: 2022/06/23/ 下午 3:58
 * @Description
 */
public class MongoCheck extends AbstractCheck implements IAbnormalCheck {
    private static Logger logger = LoggerFactory.getLogger(MongoCheck.class);

    private String uri;

    static MongoCheck inst;

    public MongoCheck(String uri) {
        this.uri = uri;
    }

    public static MongoCheck getInst(String uri) {
        if (inst == null) {
            inst = new MongoCheck(uri);
        } else {
            inst.uri = uri;
        }
        return inst;
    }

    @Override
    public void check() {
        MongoDbInfo mongoDbInfo = new MongoDbInfo(uri);
        if (!mongoDbInfo.getConnect()) {
            logger.error("Mongo 服务无法连接");
            logger.error("1.请排查Mongo服务是否正常启动");
            logger.error("2.检查网络ip/端口是否开放");
            super.shutdown();
        }

        MongoClientURI clientURI = new MongoClientURI(uri);
        MongoClient client = MongoClients.create(uri);
        try {
            client.getDatabase(clientURI.getDatabase()).listCollectionNames().iterator();//调用迭代器才会真的去查询
        } catch (MongoTimeoutException | MongoSocketOpenException e) {
            logger.error("无法连接到MongoDB请检查连接参数是否正确");
        } catch (MongoSecurityException e) {
            logger.error("Mongo数据库账号或密码错误");
            logger.error("请检查Mongo数据库连接参数: {}", uri);
        } finally {
            client.close();
        }
    }
}
