package com.northpool.devtool.model;

import com.alibaba.fastjson.JSONObject;
import com.sun.management.OperatingSystemMXBean;

import java.lang.management.ManagementFactory;
import java.math.BigDecimal;
import java.math.RoundingMode;

/**
 * @author Bai Chenguang
 * @Date: 2022/06/14/ 上午 11:46
 * @Description
 */
public class MemoryInfo {
    final static long GB = 1024 * 1024 * 1024;

    String total;
    String free;
    String swapFree;
    String swapTotal;

    OperatingSystemMXBean opt = (OperatingSystemMXBean) ManagementFactory.getOperatingSystemMXBean();

    public String getTotal() {
        return twoDecimal(1.0 * opt.getTotalPhysicalMemorySize() / GB) + " GB";
    }

    public String getFree() {
        return twoDecimal(1.0 * opt.getFreePhysicalMemorySize() / GB) + " GB";
    }

    public String getSwapFree() {
        return twoDecimal(1.0 * opt.getFreeSwapSpaceSize() / GB) + " GB";
    }

    public String getSwapTotal() {
        return twoDecimal(1.0 * opt.getTotalSwapSpaceSize() / GB) + " GB";
    }

    public static double twoDecimal(double doubleValue) {
        BigDecimal bigDecimal = new BigDecimal(doubleValue).setScale(2, RoundingMode.HALF_UP);
        return bigDecimal.doubleValue();
    }

    public static void main(String[] args) {
        MemoryInfo model = new MemoryInfo();
        System.out.println(JSONObject.toJSON(model).toString());
    }

}
