package com.northpool.devtool.model;

import com.northpool.devtool.model.abstractclass.AbstractNetConnect;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.net.URI;
import java.net.URISyntaxException;

/**
 * @author Bai Chenguang
 * @Date: 2022/06/20/ 下午 5:01
 * @Description
 */
public class ZookeeperInfo extends AbstractNetConnect {
    private static Logger logger = LoggerFactory.getLogger(ZookeeperInfo.class);
    String address;
    String root;
    String user;
    String password;
    Integer timeout;

    public ZookeeperInfo(String address){
        this(address, null, null);
    }

    public ZookeeperInfo(String address, String root, Integer timeout) {
        super(address);
        this.root = root;
        this.timeout = timeout;

        if (StringUtils.isNotBlank(address) && address.contains("@")) {
            int index = address.lastIndexOf("@");
            String[] authStr = address.substring(0, index).split(":");
            //zkAdmin:password@127.0.0.1:2181
            if (authStr.length != 2) {
                throw new RuntimeException("zookeeper 用户名密码格式错误");
            }
            this.address = address.substring(index + 1);
            this.user = authStr[0];
            this.password = authStr[1];
        } else {
            this.address = address;
        }


    }

    public Boolean hasAuth() {
        if (StringUtils.isNotBlank(this.user) && StringUtils.isNotBlank(this.password)) {
            return true;
        }
        return false;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getRoot() {
        return root;
    }

    public void setRoot(String root) {
        this.root = root;
    }

    public Integer getTimeout() {
        return timeout;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public String getUser() {
        return user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public void init(String uri) {
        try {
            String[] zkParams = uri.split("@");
            URI _uri = new URI("http://" + zkParams[zkParams.length - 1]);
            this.ip = _uri.getHost();
            this.port = _uri.getPort();
        } catch (URISyntaxException e) {
            logger.error("zookeeper 地址有误，请检查");
        }
    }
}
