/**
　 * <p>Title: TerrainServiceBuilder.java</p>
　 * <p>Description: </p>
　 * <p>Copyright: Copyright (c) 2021</p>
　 * <p>Company: northpool</p>
　 * @author chy
　 * @date 2021年12月22日
　 * @version 1.0
*/
package com.northpool.service.config.terrain_service;

import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;

import org.apache.commons.lang3.StringUtils;

import com.northpool.service.config.Constants.SERVICE_TYPE;
import com.northpool.service.config.data_service.raster.IRasterDataService;
import com.northpool.service.config.raster_service.IRasterService;
import com.northpool.service.config.raster_service.RasterServiceBean;
import com.northpool.service.config.raster_service.RasterServiceBuilder;
import com.northpool.service.config.raster_service.RasterServiceShell;
import com.northpool.service.config.raster_service.dataset.RasterDataSetBean;
import com.northpool.service.config.raster_service.layer.RasterLayerBean;
import com.northpool.service.config.vector_service.exception.DataServiceNotFoundException;
import com.northpool.service.config.vector_service.exception.ServiceNameInvalidException;
import com.northpool.service.config.vector_service.layer.LayerBean;
import com.northpool.service.exception.LoadXmlException;
import com.northpool.service.xmlloader.raster_service.TerrainServiceLoader;
import com.northpool.spatial.grid.Constants.GRID_TYPE;
import com.northpool.spatial.grid.Constants.GRID_UNIT;
import com.northpool.spatial.grid.Grid;
import com.northpool.spatial.grid.GridManager;

/**
 * @author chy
 *
 */
public class TerrainServiceBuilder extends RasterServiceBuilder {

    public IRasterService fromXmlInputStream(InputStream in) throws LoadXmlException {
        TerrainServiceLoader xml = new TerrainServiceLoader(client);
        RasterServiceBean service = xml.load(in);
        service.setVersion(String.valueOf(System.currentTimeMillis()));
        IRasterService terrainServiceShell = new RasterServiceShell(this.client, service);
        return terrainServiceShell;
    }
    
    public IRasterService fromDataService(String serverName, List<String> dataServiceIds) {
        return this.fromDataService(serverName, dataServiceIds, null, null);
    }
    
    public IRasterService fromDataService(String serverName, List<String> dataServiceIds,
            int[] origin, double[] resolutions) {
        if(dataServiceIds == null || dataServiceIds.isEmpty()) {
            return null;
        }
        if(StringUtils.isEmpty(serverName)) {
            throw new ServiceNameInvalidException(serverName);
        }
        RasterServiceBean terrainService = RasterServiceBean.initTerrain();
        terrainService.setId(serverName);
        terrainService.setVersion(String.valueOf(System.currentTimeMillis()));

        //查询dataservice
        List<IRasterDataService> rasterDataServices = new LinkedList<>();
        dataServiceIds.stream().forEach(dataServiceId -> {
            IRasterDataService rasterDataService = client.getRasterDataServiceManager().get(dataServiceId);
            if(rasterDataService != null) {
                SERVICE_TYPE serviceType = rasterDataService.getServiceType();
                if(serviceType != SERVICE_TYPE.terrain_data_service) {
                    throw new RuntimeException(StringUtils.join("数据服务类型为：",
                            serviceType.name(), "，不能作为地形服务成员"));
                }
                rasterDataServices.add(rasterDataService);
            } else {
                throw new DataServiceNotFoundException(dataServiceId);
            }
        });

        //检查空间参考，检查重名
        Integer srid;
        try {
            srid = this.getSrid(rasterDataServices);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }

        GRID_TYPE gridType = GRID_TYPE.tdt;
        if (origin != null && resolutions != null){
            gridType = GRID_TYPE.esri;
        }

        //获取格网信息
        GRID_UNIT gridBase = com.northpool.spatial.Constants.getGridUnitBySrid(srid);
        //由于平面坐标系分带号对应的srid较多，不适合一一列举，默认若srid未在map中即认为是投影坐标系
        if(null == gridBase) {
            gridBase = GRID_UNIT.meter;
        }
        
        String gridTreeName = gridType.name() + "_" + gridBase.name() + "_base512";

        terrainService.setGridTreeName(gridTreeName);
        terrainService.setResolutions(resolutions);
        terrainService.setOrigin(origin);

        Grid grid = GridManager.getQuadtreeGrid(gridTreeName);

        Integer startLevel = grid.getBeginLevel();

        Integer endLevel = LayerBean.MAX_LEVEL;

        // 解析数据集
        LinkedHashMap<String, RasterDataSetBean> dataSetMap = this.getDataSetMap(rasterDataServices);
        
        terrainService.setDataSetMap(dataSetMap);

        // 解析图层
        LinkedHashMap<String, RasterLayerBean> layerMap = this.getLayerMap(rasterDataServices,
                dataSetMap, startLevel, endLevel);

        terrainService.setLayerMap(layerMap);

        IRasterService terrainServiceShell = new RasterServiceShell(this.client, terrainService);

        return terrainServiceShell;
    }
    
}
