package com.northpool.service.config.vector_service;

import com.northpool.bean.Idable;
import com.northpool.bean.Jsonable;
import com.northpool.bean.Markable;
import com.northpool.service.client.Client;
import com.northpool.service.config.*;
import com.northpool.service.config.data_service.FieldsConfig;
import com.northpool.service.config.vector_service.layer.ILayer;
import com.northpool.service.config.vector_service.storage.IStorageInfo;
import com.northpool.service.config.vector_service.utfgrid.IUtfgridInfo;
import com.northpool.spatial.grid.Grid;

import java.util.List;
import java.util.Map;

public interface IVectorService extends IService, Jsonable, Markable, Idable<String>, IDocumentAble, CanStartStop,ICacheable, IVersionAble, IBeanShell<VectorServiceBean> {
    void addUtfgridInfo(IUtfgridInfo utfgridInfo);

    void addCacheInfo(ICacheable cacheInfo);

    /**
	 * ID
	 * @return
	 */
	public String getId();
	/**
	 * 名称
	 * @return
	 */
	public String getName();
	/**
	 * 更新版本号
	 * @return
	 */
	public String getVersion();
	/**
	 * GRID
	 * @return
	 */
	public Grid getGridTree();
	/**
	 * 等级
	 * @return
	 */
	//public VECTOR_SERVICE_LEVEL getLevel();
	/**
	 * 四至范围
	 * @return
	 */
	public String getBbox();
	/**
	 * 开始级别
	 * @return
	 */
	public Integer getBeginLevel();
	/**
	 * 结束级别
	 * @return
	 */
	public Integer getEndLevel();
	
	
	/**
	 * 获得所有的图层
	 * @return
	 */
	public Map<String, ILayer> getLayerMap();
	/**
	 * 是否是单图层服务
	 * @return
	 */
	public Boolean isSinglelayer();
	
	
	/**
	 * 是否允许缓存
	 * @return
	 */
	public Boolean allowCache();


	public Client getClient();


	public void refresh();
	
	
	public static IVectorService create(Client client,VectorServiceBean vectorService){
		return new VectorServiceShell(client,vectorService);
	}


	public void addStorageInfo(IStorageInfo storageInfo);

	public ICacheable getCacheInfo();

	public IStorageInfo getStorageInfo();

	public IUtfgridInfo getUtfgridInfo();

	List<FieldsConfig> getLayerFields(ILayer layer);

	String getLayerIdFieldName(ILayer layer);

	String getLayerIdFieldType(ILayer layer);

	String getLayerGeometryType(ILayer layer);

	int[] getOrigin();

	double[] getResolutions();

	List<String> getDataServiceIds();
}
