package com.northpool.service.manager;

import com.northpool.service.client.Client;
import com.northpool.service.manager.exception.ManagerDuplicateException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Iterator;
import java.util.ServiceLoader;

public class ManagerFactory {

    static Logger logger = LoggerFactory.getLogger(ManagerFactory.class);

    static ClassLoader loader;

    public static  <T extends IClientManager> T getManager(Class<T> type, Client client) throws Exception {
        if (loader != null){//每次重置一次loader，以防被其他程序篡改
        	
            Thread.currentThread().setContextClassLoader(loader);
        }
        ServiceLoader<T> loader = ServiceLoader.load(type);
        Iterator<T> iterator = loader.iterator();
        T manager = null;
        int count = 0;
        while (iterator.hasNext()){
            count ++;
            manager = iterator.next();
         //   System.out.println(manager);
        }

        if (count > 1){
            throw new ManagerDuplicateException(type.getName() + "有多个实现类");
        }
        if (manager != null){
            manager.setClient(client);
            try {
                manager.init();
            } catch (Exception e) {
                logger.error(type.getName() + "初始化失败");
                throw e;
            }
        }
        return manager;
    }

    public static void setLoader(ClassLoader loader) {
        ManagerFactory.loader = loader;
    }
}
