package com.northpool.service.manager.data_sources;

import com.northpool.exception.NotSupport;
import com.northpool.resources.command.Constants;
import com.northpool.resources.command.QueryFilter;
import com.northpool.resources.datatable.dao.IScroll;
import com.northpool.service.config.data_service.IDataService;
import com.northpool.service.config.data_source.DataSourceBuilder;
import com.northpool.service.config.data_source.IDataSourceInService;
import com.northpool.service.config.vector_service.IVectorService;
import com.northpool.service.config.vector_service.layer.ILayer;
import com.northpool.service.config.vector_service.layer.ILayerLevel;
import com.northpool.service.dao.IMetaDataDao;
import com.northpool.service.dao.data_sources.DataSourceIgniteDao;
import com.northpool.service.dao.data_sources.DataSourcesZkDao;
import com.northpool.service.manager.abstractclass.AbstractManager;
import com.northpool.service.manager.abstractclass.EventMessage.EVENT_TYPE;
import com.northpool.service.manager.abstractclass.ZKException;
import com.northpool.service.manager.data_service.IDataServiceManager;
import com.northpool.service.manager.vector_service.IVectorServiceManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;


public class DataSourcesManager extends AbstractManager<IDataSourceInService,DataSourceBuilder> implements IDataSourcesManager {
	
	protected static final String MANAGER_ROOT = "data_sources";



	protected Logger logger = LoggerFactory.getLogger(DataSourcesManager.class);

	public DataSourcesManager() {
		super(DataSourceBuilder.getInstance(), MANAGER_ROOT);

	}

/*	public void init() throws Exception {
		this.beanBuilder.setClient(client);
		if (client.getZoo() != null) {
			this.metaDataDao = new DataSourcesZkDao(idFieldName, beanBuilder, table, client, managerRoot, readOnly);
			this.metaDataDao.init();
		}
		super.init();

	}*/
	
	protected void addListener(){
		/*this.on(EVENT_TYPE.register, (String id ,IDataSource<?> t)->{
			
		});*/
		this.on(EVENT_TYPE.unRegister, (String id ,IDataSourceInService t) ->{
			logger.info("数据源" + id + "已被删除");
			t.destory();
		});
		
		this.on(EVENT_TYPE.update, (String id ,IDataSourceInService t) ->{
			logger.info("数据源" + id + "已更新");
			t.resetConnection();
		});
	}
	
	
	@Override
	public void register(IDataSourceInService t) throws Exception {
		super.doAdd(t);
	}
	
	
	@Override
	public void unRegister(String id) throws Exception {
		//IDataSourceInService dataSource = this.get(id);
		/*if(dataSource != null){
			dataSource.destory();
		}*/
		super.doRemove(id);
		
	}

	@Override
	public void update(IDataSourceInService t) throws Exception {
		//t.resetConnection();
		super.doUpdate(t);

		IVectorServiceManager vectorServiceManager = client.getVectorServiceManager();
		IDataServiceManager dataServiceManager = client.getDataServiceManager();
		List<IVectorService> vectorServices = new ArrayList<>();
		List<IDataService> dataServices = new ArrayList<>();

		if (t.getDataSourceType() == com.northpool.resources.Constants.DATA_SOURCE_TYPE.mongodb){//把瓦片数据源为该数据源的数据服务和地图服务找出来
			QueryFilter cacheFilter = new QueryFilter();
			//cacheFilter.addFilter("storageInfo", Constants.OPERATION.IS_NOT_NULL);
			List<IVectorService> cacheServices = vectorServiceManager.list(cacheFilter).stream().filter(vectorService -> vectorService.getStorageInfo() != null).filter(vectorService -> vectorService.getStorageInfo().getBean().getDataSourceId().equals(t.getId())).collect(Collectors.toList());
			vectorServices.addAll(cacheServices);

			cacheFilter = new QueryFilter();
			//cacheFilter.addFilter("storageInfo", Constants.OPERATION.IS_NOT_NULL);
			List<IDataService> cacheList = dataServiceManager.list(cacheFilter).stream().filter(vectorService -> vectorService.getStorageInfo() != null).filter(dataService -> dataService.getStorageInfo().getBean().getDataSourceId().equals(t.getId())).collect(Collectors.toList());
			dataServices.addAll(cacheList);
		}else {//把直连数据源为该数据源的数据服务找出来
			QueryFilter filter = new QueryFilter();
			filter.addFilter("dataSourceId", Constants.OPERATION.EQ, t.getId());
			dataServices = dataServiceManager.list(filter);
		}

		//把用到上述数据服务的地图服务找出来
		List<IVectorService> services = vectorServiceManager.list(new QueryFilter());
		List<IVectorService> dataVectorServices = dataServices.stream().flatMap(dataService -> {
			return services.stream().filter(service -> {
				Iterator<ILayer> it = service.getLayerMap().values().iterator();
				while (it.hasNext()){
					ILayer layer = it.next();
					Iterator<ILayerLevel> levelIterator = layer.getLevelMap().values().iterator();
					while (levelIterator.hasNext()){
						ILayerLevel level = levelIterator.next();
						if (dataService.getId().equals(level.getDataSet().getDataService().getId())){
							return true;
						}
					}
				}
				return false;
			});
		}).collect(Collectors.toList());

		if (!dataVectorServices.isEmpty()){
			vectorServices.addAll(dataVectorServices);
		}

		//更新相关服务
		for (int i = 0; i < vectorServices.size(); i++) {
			vectorServiceManager.update(vectorServices.get(i));

		}
	}

	
	public IScroll<IDataSourceInService> scroll(QueryFilter queryFilter){
		return super.scroll(queryFilter);
	}


	@Override
	protected IMetaDataDao<IDataSourceInService> getMetaDataDao() throws Exception {
		if (this.metaDataDao == null) {
			if (client.getZoo() != null) {
				DataSourcesZkDao metaDataDao = new DataSourcesZkDao(idFieldName, beanBuilder, table, client, managerRoot, readOnly);
				metaDataDao.init();
				this.metaDataDao = metaDataDao;
			}else if (client.getIgnite() != null){
				DataSourceIgniteDao igniteDao = new DataSourceIgniteDao(idFieldName, table, client, managerRoot, readOnly, client.getIgnite());
				igniteDao.init();
				this.metaDataDao = igniteDao;
			}
		}
		return this.metaDataDao;
	}

	@Override
	public IDataSourceInService findOne(QueryFilter queryFilter) {
		// TODO Auto-generated method stub
		queryFilter.setStart(0);
		queryFilter.setLimit(1);
		List<IDataSourceInService> iList = super.list(queryFilter);
		if(iList == null || iList.isEmpty()){
			return null;
		}else{
			return iList.get(0);
		}
	}

	@Override
	public boolean checkVersion(String id, String version) {
		return false;
	}

	@Override
	public void start(String id) throws ZKException {
		// TODO Auto-generated method stub
		throw new NotSupport();
	}

	@Override
	public void stop(String id) throws ZKException {
		// TODO Auto-generated method stub
		throw new NotSupport();
	}

	@Override
	public void rename(String id, String newName) throws ZKException {
		// TODO Auto-generated method stub
		throw new NotSupport();
	}


}
