package com.northpool.service.mapserver;

import com.northpool.devtool.AbnormalCheck.MapserverCheck;
import com.northpool.service.utils.HttpRequestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpStatus;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;

import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;

public class MapServerAccess {
	 // utf-8字符编码
    public static final String CHARSET_UTF_8 = "utf-8";

    // HTTP内容类型。
    public static final String CONTENT_TYPE_TEXT_HTML = "text/xml";

    // HTTP内容类型。相当于form表单的形式，提交数据
    public static final String CONTENT_TYPE_FORM_URL = "application/x-www-form-urlencoded";

    // HTTP内容类型。相当于form表单的形式，提交数据
    public static final String CONTENT_TYPE_JSON_URL = "application/json;charset=utf-8";
   
    // 连接管理器
    private PoolingHttpClientConnectionManager pool;
    
    // 请求配置
    private RequestConfig requestConfig;

    private static String urlPrifix;

    protected static final String SAVE_STYLE_URL = "/styleInfo/save.do";

    public final static String createMergeGridUrl = "%s/%s/build/mergeGrid?x=%s&y=%s&l=%s";

    public final static String createUtfGridUrl = "%s/%s/build/createGrid?x=%s&y=%s&l=%s";

    protected static final String ACCESS_ERROR_MESSAGE = "渲染引擎访问异常";

    public MapServerAccess(int maxTotal, int timeout){
        Registry<ConnectionSocketFactory> socketFactoryRegistry = RegistryBuilder.<ConnectionSocketFactory> create()
                .register("http", PlainConnectionSocketFactory.getSocketFactory())
                .register("https", new SSLConnectionSocketFactory(createIgnoreVerifySSL())).build();
    	
    	pool = new PoolingHttpClientConnectionManager(
		        socketFactoryRegistry);
    	
    	pool.setMaxTotal(maxTotal);
		
		pool.setDefaultMaxPerRoute(maxTotal);
    	
        this.requestConfig = RequestConfig.custom().setSocketTimeout(Integer.MAX_VALUE).setConnectTimeout(timeout)
                .setConnectionRequestTimeout(timeout).build();
    }
    
    private CloseableHttpClient getHttpClient() {
        
        CloseableHttpClient httpClient = HttpClients.custom()
                // 设置连接池管理
                .setConnectionManager(pool)
                // 设置请求配置
                .setDefaultRequestConfig(requestConfig)
                // 设置重试次数
                .setRetryHandler(new DefaultHttpRequestRetryHandler(2, true))
                
                .build();
        
        return httpClient;
    }


    /**
     * 发送Post请求
     * 
     * @param httpPost
     * @return
     */
    private static String sendHttpPost(HttpPost httpPost) {

        CloseableHttpClient httpClient = null;
        CloseableHttpResponse response = null;
        // 响应内容
        String responseContent = null;
        try {
            // 创建默认的httpClient实例.
            httpClient = HttpClients.createDefault();//此处不使用长链接，以防后端服务重启造成的连接异常
            // 配置请求信息
            //httpPost.setConfig(requestConfig);
            // 执行请求
            response = httpClient.execute(httpPost);
            // 得到响应实例
            HttpEntity entity = response.getEntity();

            // 判断响应状态
            if (response.getStatusLine().getStatusCode() >= 300) {
                throw new Exception(
                        "HTTP Request is not success, Response code is " + response.getStatusLine().getStatusCode() + ", error:" + responseContent);
            }

            if (HttpStatus.SC_OK == response.getStatusLine().getStatusCode()) {
                responseContent = EntityUtils.toString(entity, CHARSET_UTF_8);
                EntityUtils.consume(entity);
            }

        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            try {
                // 释放资源
                if (response != null) {
                    response.close();
                }
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        return responseContent;
    }

    /**
     * 发送Get请求
     * 
     * @param httpGet
     * @return
     */
    private String sendHttpGet(HttpGet httpGet) {

        CloseableHttpClient httpClient = null;
        CloseableHttpResponse response = null;
        // 响应内容
        String responseContent = null;
        try {
            // 创建默认的httpClient实例.
            httpClient = getHttpClient();
            // 配置请求信息
            httpGet.setConfig(requestConfig);
            // 执行请求
            response = httpClient.execute(httpGet);
            // 得到响应实例
            HttpEntity entity = response.getEntity();

            if (response.getStatusLine().getStatusCode() >= 300) {
            	responseContent = EntityUtils.toString(entity, CHARSET_UTF_8);
                EntityUtils.consume(entity);
                throw new Exception(
                        "HTTP Request is not success, Response code is " + response.getStatusLine().getStatusCode() + ", error:" + responseContent);
            }
            

            if (HttpStatus.SC_OK == response.getStatusLine().getStatusCode()) {
                responseContent = EntityUtils.toString(entity, CHARSET_UTF_8);
                EntityUtils.consume(entity);
            }

        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            try {
                // 释放资源
                if (response != null) {
                    response.close();
                }
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        return responseContent;
    }
    
    public static String saveStyle(String belongService, String styleId, String styleJson) throws MapserverAccessException {
        String[] names = new String[] {"ownServer","name","desc","styleJson"};
        String[] values = new String[] {belongService, styleId, "", styleJson};

        //String result = postUrlEncoded(urlPrifix + SAVE_STYLE_URL, names, values);
        MapserverCheck.getInst(urlPrifix).check();
        HttpPost request = HttpRequestUtils.buildUrlEncodedRequest(urlPrifix + SAVE_STYLE_URL, names, values);

        String result = sendHttpPost(request);

        if(StringUtils.isEmpty(result)){
            throw new MapserverAccessException(ACCESS_ERROR_MESSAGE);
        }

        return result;

    }

    public static String saveStyle(String belongService, String styleId, String styleJson, Double xmin, Double ymin, Double xmax, Double ymax) throws MapserverAccessException {
        String[] names = new String[] {"ownServer","name","desc","styleJson","xmin","ymin","xmax", "ymax"};
        String[] values = new String[] {belongService, styleId, "", styleJson, xmin+"", ymin+"", xmax+"",ymax+"" };

        //String result = postUrlEncoded(urlPrifix + SAVE_STYLE_URL, names, values);
        MapserverCheck.getInst(urlPrifix).check();
        HttpPost request = HttpRequestUtils.buildUrlEncodedRequest(urlPrifix + SAVE_STYLE_URL, names, values);

        String result = sendHttpPost(request);

        if(StringUtils.isEmpty(result)){
            throw new MapserverAccessException(ACCESS_ERROR_MESSAGE);
        }

        return result;

    }
    
    
    public String sendHttpGet(String httpUrl) {
        // 创建get请求
        HttpGet httpGet = new HttpGet(httpUrl);
        return sendHttpGet(httpGet);
    }

    public static SSLContext createIgnoreVerifySSL() {
        SSLContext sc = null;
        try {
            sc = SSLContext.getInstance("SSLv3");

            // 实现一个X509TrustManager接口，用于绕过验证，不用修改里面的方法
            X509TrustManager trustManager = new X509TrustManager() {
                @Override
                public void checkClientTrusted(java.security.cert.X509Certificate[] paramArrayOfX509Certificate,
                                               String paramString) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(java.security.cert.X509Certificate[] paramArrayOfX509Certificate,
                                               String paramString) throws CertificateException {
                }

                @Override
                public java.security.cert.X509Certificate[] getAcceptedIssuers() {
                    return null;
                }
            };

            sc.init(null, new TrustManager[] { trustManager }, null);
        } catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        } catch (KeyManagementException e) {
            e.printStackTrace();
        }
        return sc;
    }

    public static void setUrlPrifix(String urlPrifix) {
        MapServerAccess.urlPrifix = urlPrifix;
    }

    public String getUrlPrifix() {
        //使用的时候才去检查引擎连接是否可用
        MapserverCheck.getInst(urlPrifix).check();
        return urlPrifix;
    }
}
