/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.service.config.data_service;

import com.alibaba.fastjson.JSON;
import com.northpool.resources.datatable.FieldEncoder;
import com.northpool.service.config.CanStartStop;
import com.northpool.service.config.Constants;
import com.northpool.service.config.data_service.DataServiceAdvancedOptions;
import com.northpool.service.config.data_service.FieldsConfig;
import com.northpool.service.config.data_service.tileInfo.AreaTileInfoBean;
import com.northpool.service.config.data_service.tileInfo.FeatureTileInfoBean;
import com.northpool.service.config.vector_service.storage.StorageInfoBean;
import com.northpool.spatial.grid.Constants;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class DataServiceBean {
    protected String id;
    protected String name;
    protected String filter;
    protected String spatialOriginFieldName;
    protected String geoType;
    protected String dataSourceId;
    protected String tableName;
    protected Boolean readonly = false;
    protected Constants.SERVICE_TYPE serviceType = Constants.SERVICE_TYPE.data_service;
    protected CanStartStop.STATE_TYPE state = CanStartStop.STATE_TYPE.standby;
    protected List<FieldsConfig> fields = new ArrayList<FieldsConfig>();
    Constants.GRID_UNIT gridUnit = Constants.GRID_UNIT.degree;
    protected LinkedHashMap<String, String> aliasMap = new LinkedHashMap();
    protected DataServiceAdvancedOptions advancedOptions = new DataServiceAdvancedOptions();
    protected StorageInfoBean storageInfo;
    protected AreaTileInfoBean areaTileInfo;
    protected FeatureTileInfoBean featureTileInfo;
    protected String version;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Map<String, String> getAliasMap() {
        return this.aliasMap;
    }

    public void setAliasMap(LinkedHashMap<String, String> aliasMap) {
        this.aliasMap = aliasMap;
    }

    public DataServiceBean() {
    }

    public DataServiceBean(String id, String spatialOriginFieldName, String dataSourceId, String tableName, Boolean readonly, String[] fields, LinkedHashMap<String, String> aliasMap) {
        this.id = id;
        this.name = id;
        this.spatialOriginFieldName = spatialOriginFieldName;
        this.dataSourceId = dataSourceId;
        this.tableName = tableName;
        this.readonly = readonly;
        if (aliasMap == null) {
            aliasMap = new LinkedHashMap();
        }
        for (String field : fields) {
            String aliaseName = aliasMap.get(field);
            if (aliaseName == null) {
                aliaseName = FieldEncoder.DEFAULT_ENCODER.encode(field);
            }
            aliasMap.put(field, aliaseName);
        }
        this.aliasMap = aliasMap;
    }

    public DataServiceBean(String id, String name, String spatialOriginFieldName, String dataSourceId, String tableName, Boolean readonly, String[] fields, LinkedHashMap<String, String> aliasMap) {
        this.id = id;
        this.name = name;
        this.spatialOriginFieldName = spatialOriginFieldName;
        this.dataSourceId = dataSourceId;
        this.tableName = tableName;
        this.readonly = readonly;
        if (aliasMap == null) {
            aliasMap = new LinkedHashMap();
        }
        for (String field : fields) {
            String aliaseName = aliasMap.get(field);
            if (aliaseName == null) {
                aliaseName = FieldEncoder.DEFAULT_ENCODER.encode(field);
            }
            aliasMap.put(field, aliaseName);
        }
        this.aliasMap = aliasMap;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getSpatialOriginFieldName() {
        return this.spatialOriginFieldName;
    }

    public String getSpatialFieldName() {
        return this.aliasMap.get(this.spatialOriginFieldName);
    }

    public void setSpatialOriginFieldName(String spatialOriginFieldName) {
        this.spatialOriginFieldName = spatialOriginFieldName;
    }

    public String getDataSourceId() {
        return this.dataSourceId;
    }

    public void setDataSourceId(String dataSourceId) {
        this.dataSourceId = dataSourceId;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public Boolean getReadonly() {
        return this.readonly;
    }

    public void setReadonly(Boolean readonly) {
        this.readonly = readonly;
    }

    public Constants.SERVICE_TYPE getServiceType() {
        return this.serviceType;
    }

    public void setServiceType(Constants.SERVICE_TYPE serviceType) {
        this.serviceType = serviceType;
    }

    public CanStartStop.STATE_TYPE getState() {
        return this.state;
    }

    public void setState(CanStartStop.STATE_TYPE state) {
        this.state = state;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public String toJson() {
        return JSON.toJSONString((Object)this);
    }

    public List<FieldsConfig> getFields() {
        return this.fields;
    }

    public void setFields(List<FieldsConfig> fields) {
        this.fields = fields;
    }

    public StorageInfoBean getStorageInfo() {
        return this.storageInfo;
    }

    public void setStorageInfo(StorageInfoBean storageInfo) {
        this.storageInfo = storageInfo;
    }

    public AreaTileInfoBean getAreaTileInfo() {
        return this.areaTileInfo;
    }

    public void setAreaTileInfo(AreaTileInfoBean areaTileInfo) {
        this.areaTileInfo = areaTileInfo;
    }

    public FeatureTileInfoBean getFeatureTileInfo() {
        return this.featureTileInfo;
    }

    public void setFeatureTileInfo(FeatureTileInfoBean featureTileInfo) {
        this.featureTileInfo = featureTileInfo;
    }

    public DataServiceAdvancedOptions getAdvancedOptions() {
        return this.advancedOptions;
    }

    public void setAdvancedOptions(DataServiceAdvancedOptions advancedOptions) {
        this.advancedOptions = advancedOptions;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getGeoType() {
        return this.geoType;
    }

    public void setGeoType(String geoType) {
        this.geoType = geoType;
    }

    public Constants.GRID_UNIT getGridUnit() {
        return this.gridUnit;
    }

    public void setGridUnit(Constants.GRID_UNIT gridUnit) {
        this.gridUnit = gridUnit;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataServiceBean that = (DataServiceBean)o;
        String fields = StringUtils.join(this.aliasMap.keySet(), (String)",");
        String thatFields = StringUtils.join(that.getAliasMap().keySet(), (String)",");
        return new EqualsBuilder().append((Object)this.name, (Object)that.name).append((Object)this.spatialOriginFieldName, (Object)that.spatialOriginFieldName).append((Object)this.dataSourceId, (Object)that.dataSourceId).append((Object)this.tableName, (Object)that.tableName).append((Object)this.serviceType, (Object)that.serviceType).append((Object)fields, (Object)thatFields).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.name).append((Object)this.spatialOriginFieldName).append((Object)this.dataSourceId).append((Object)this.tableName).append((Object)this.serviceType).append(this.aliasMap).toHashCode();
    }
}

