/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.service.config.vector_service;

import com.northpool.resources.MongodbFactory;
import com.northpool.resources.command.Constants;
import com.northpool.resources.command.QueryFilter;
import com.northpool.resources.datasource.MongodbDataSource;
import com.northpool.service.client.Client;
import com.northpool.service.config.data_source.IDataSourceInService;
import com.northpool.service.config.style.IStyleService;
import com.northpool.service.config.vector_service.CacheInfoBean;
import com.northpool.service.config.vector_service.ICacheable;
import com.northpool.service.manager.style.IStyleManager;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class CacheInfoShell
implements ICacheable {
    protected Client client;
    protected CacheInfoBean cacheInfo;

    public CacheInfoShell(Client client, CacheInfoBean cacheInfo) {
        this.client = client;
        this.cacheInfo = cacheInfo;
    }

    @Override
    public boolean needDataCache() {
        return this.cacheInfo.needDataCache;
    }

    @Override
    public boolean needImgCache() {
        return this.cacheInfo.needImgCache;
    }

    @Override
    public String getImgScript() {
        return this.cacheInfo.imgScript;
    }

    @Override
    public IDataSourceInService getDataCacheSource() {
        String dataCacheSourceId = this.cacheInfo.dataCacheSourceId;
        IDataSourceInService dataSource = (IDataSourceInService)this.client.getDataSourcesManager().get(dataCacheSourceId);
        if (dataSource == null) {
            throw new RuntimeException(String.format("\u6ca1\u6709\u627e\u5230\u6570\u636e\u6e90ID\u4e3a%s\u7684\u6570\u636e\u6e90", dataCacheSourceId));
        }
        return dataSource;
    }

    @Override
    public IDataSourceInService getImgCacheSource() {
        String imgCacheSourceId = this.cacheInfo.imgCacheSourceId;
        IDataSourceInService dataSource = (IDataSourceInService)this.client.getDataSourcesManager().get(imgCacheSourceId);
        if (dataSource == null) {
            throw new RuntimeException(String.format("\u6ca1\u6709\u627e\u5230\u6570\u636e\u6e90ID\u4e3a%s\u7684\u6570\u636e\u6e90", imgCacheSourceId));
        }
        return dataSource;
    }

    @Override
    public String getDataScript() {
        return this.cacheInfo.getDataScript();
    }

    @Override
    public CacheInfoBean getCacheInfoBean() {
        return this.cacheInfo;
    }

    @Override
    public void drop(String serverName, String styleId) throws Exception {
        if (StringUtils.isEmpty((CharSequence)styleId)) {
            IStyleManager styleManager = this.client.getStyleManager();
            QueryFilter filter = new QueryFilter();
            filter.addFilter("ownServer", Constants.OPERATION.EQ, new Object[]{serverName});
            List<IStyleService> styleList = styleManager.list(filter);
            for (int i = 0; i < styleList.size(); ++i) {
                this.dropStyle(serverName, styleList.get(i).getName());
            }
        } else {
            this.dropStyle(serverName, styleId);
        }
    }

    private void dropStyle(String serverName, String styleId) {
        String storageName = serverName + "_" + styleId + "_img_cache";
        IDataSourceInService dataSourceInService = (IDataSourceInService)this.client.getDataSourcesManager().get(this.cacheInfo.getImgCacheSourceId());
        MongodbFactory factory = ((MongodbDataSource)dataSourceInService.getBean()).factory();
        factory.dropCollection(storageName);
    }
}

