/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.service.config.vector_service;

import com.alibaba.fastjson.JSON;
import com.northpool.bean.JsonableBuilder;
import com.northpool.resources.datatable.SpatialInfo;
import com.northpool.service.client.Client;
import com.northpool.service.config.Constants;
import com.northpool.service.config.IBeanBuilder;
import com.northpool.service.config.data_service.DataServiceBean;
import com.northpool.service.config.data_service.IDataService;
import com.northpool.service.config.vector_service.IVectorService;
import com.northpool.service.config.vector_service.VectorServiceBean;
import com.northpool.service.config.vector_service.VectorServiceShell;
import com.northpool.service.config.vector_service.dataset.DataSetBean;
import com.northpool.service.config.vector_service.exception.DataServiceNameDuplicateException;
import com.northpool.service.config.vector_service.exception.DataServiceNotFoundException;
import com.northpool.service.config.vector_service.exception.LayerCreateException;
import com.northpool.service.config.vector_service.exception.NoDataServiceNameException;
import com.northpool.service.config.vector_service.exception.NoSpatialReferenceException;
import com.northpool.service.config.vector_service.exception.ServiceNameInvalidException;
import com.northpool.service.config.vector_service.exception.SpatialReferenceConflictException;
import com.northpool.service.config.vector_service.layer.Label;
import com.northpool.service.config.vector_service.layer.LayerBean;
import com.northpool.service.config.vector_service.layer.LayerLevelBean;
import com.northpool.service.exception.LoadXmlException;
import com.northpool.service.manager.abstractclass.DocumentableBuilder;
import com.northpool.service.xmlloader.vectorservice.VectorServiceLoader;
import com.northpool.spatial.Constants;
import com.northpool.spatial.grid.Constants;
import com.northpool.spatial.grid.GridManager;
import com.northpool.spatial.grid.QuadtreeGrid;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.bson.Document;

public class VectorServiceBuilder
implements JsonableBuilder<IVectorService>,
DocumentableBuilder<IVectorService>,
IBeanBuilder {
    private Client client;

    public VectorServiceBuilder() {
    }

    public VectorServiceBuilder(Client client) {
        this.client = client;
    }

    public IVectorService fromJson(String str) throws Exception {
        VectorServiceBean vectorService = null;
        try {
            vectorService = (VectorServiceBean)JSON.parseObject((String)str, VectorServiceBean.class);
        }
        catch (Exception e) {
            throw new Exception(String.format("\u89e3\u6790JSON\u5931\u8d25:%s \u4e0d\u80fd\u7ffb\u8bd1\u6210vectorService", str));
        }
        if (vectorService.getId() == null) {
            return null;
        }
        VectorServiceShell vectorServiceShell = new VectorServiceShell(this.client, vectorService);
        return vectorServiceShell;
    }

    @Override
    public IVectorService fromDocument(Document str) throws Exception {
        str.remove((Object)"_id");
        return this.fromJson(str.toJson());
    }

    public IVectorService fromXmlInputStream(InputStream in) throws LoadXmlException {
        VectorServiceLoader xml = new VectorServiceLoader(this.client);
        VectorServiceBean service = xml.load(in);
        service.setVersion(String.valueOf(System.currentTimeMillis()));
        VectorServiceShell VectorServiceShell2 = new VectorServiceShell(this.client, service);
        return VectorServiceShell2;
    }

    public IVectorService fromDataService(String serverName, List<String> dataServiceIds) {
        return this.fromDataService(serverName, dataServiceIds, null, null);
    }

    public IVectorService fromDataService(String serverName, List<String> dataServiceIds, int[] origin, double[] resolutions) {
        Constants.GRID_UNIT gridUnit;
        if (dataServiceIds == null || dataServiceIds.isEmpty()) {
            return null;
        }
        if (StringUtils.isEmpty((CharSequence)serverName)) {
            throw new ServiceNameInvalidException(serverName);
        }
        VectorServiceBean vectorService = new VectorServiceBean();
        vectorService.setId(serverName);
        vectorService.setVersion(String.valueOf(System.currentTimeMillis()));
        LinkedList<IDataService> dataServices = new LinkedList<IDataService>();
        dataServiceIds.stream().forEach(dataServiceId -> {
            IDataService dataService = (IDataService)this.client.getDataServiceManager().get((String)dataServiceId);
            if (dataService == null) {
                throw new DataServiceNotFoundException((String)dataServiceId);
            }
            dataServices.add(dataService);
        });
        try {
            gridUnit = this.getGridUnit(dataServices);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Constants.GRID_TYPE gridType = Constants.GRID_TYPE.tdt;
        if (origin != null && resolutions != null) {
            gridType = Constants.GRID_TYPE.esri;
        }
        String gridTreeName = gridType.name() + "_" + gridUnit.name() + "_base512";
        vectorService.setGridTreeName(gridTreeName);
        vectorService.setResolutions(resolutions);
        vectorService.setOrigin(origin);
        QuadtreeGrid grid = GridManager.getQuadtreeGrid((String)gridTreeName);
        Integer startLevel = grid.getBeginLevel();
        Integer endLevel = LayerBean.MAX_LEVEL;
        Map<String, DataSetBean> dataSetMap = this.getDataSetMap(dataServices);
        vectorService.setDataSetMap(dataSetMap);
        Map<String, LayerBean> layerMap = this.getLayerMap(dataServices, dataSetMap, startLevel, endLevel);
        vectorService.setLayerMap(layerMap);
        VectorServiceShell VectorServiceShell2 = new VectorServiceShell(this.client, vectorService);
        return VectorServiceShell2;
    }

    private Constants.GRID_UNIT getGridUnit(List<IDataService> dataServices) {
        HashSet<Integer> sridSet = new HashSet<Integer>();
        HashSet<String> namesSet = new HashSet<String>();
        HashSet<Constants.GRID_UNIT> gridUnitSet = new HashSet<Constants.GRID_UNIT>();
        for (IDataService dataService : dataServices) {
            Constants.GRID_UNIT gridUnit;
            String dataServiceName = dataService.getName();
            if (StringUtils.isBlank((CharSequence)dataServiceName)) {
                throw new NoDataServiceNameException();
            }
            if (namesSet.contains(dataServiceName)) {
                throw new DataServiceNameDuplicateException(dataServiceName);
            }
            namesSet.add(dataServiceName);
            SpatialInfo info = null;
            try {
                info = dataService.getTable().spatialInfo();
            }
            catch (Exception e) {
                throw new LayerCreateException(e);
            }
            Integer srid = info.getSrid();
            if (srid == null) {
                throw new NoSpatialReferenceException();
            }
            if (!sridSet.contains(srid)) {
                sridSet.add(info.getSrid());
            }
            if ((gridUnit = ((DataServiceBean)dataService.getBean()).getGridUnit()) == null) {
                gridUnit = Constants.getGridUnitBySrid((Integer)srid);
            }
            gridUnitSet.add(gridUnit);
            if (gridUnitSet.size() <= 1) continue;
            throw new SpatialReferenceConflictException(sridSet);
        }
        return (Constants.GRID_UNIT)gridUnitSet.iterator().next();
    }

    private Map<String, DataSetBean> getDataSetMap(List<IDataService> dataServices) {
        Map<String, DataSetBean> dataSetMap = dataServices.stream().map(dataService -> {
            DataSetBean dataSet = new DataSetBean();
            dataSet.setId(dataService.getName());
            dataSet.setDataServiceId((String)dataService.getId());
            dataSet.setFilter(((DataServiceBean)dataService.getBean()).getFilter());
            return dataSet;
        }).collect(Collectors.toMap(dataSetBean -> dataSetBean.getId(), dataSetBean -> dataSetBean));
        return dataSetMap;
    }

    private Map<String, LayerBean> getLayerMap(List<IDataService> dataServices, Map<String, DataSetBean> dataSetMap, Integer beginLevel, Integer endLevel) {
        Map<String, LayerBean> layerMap = dataServices.stream().map(dataService -> {
            try {
                return this.createLayer((IDataService)dataService, (DataSetBean)dataSetMap.get(dataService.getName()), beginLevel, endLevel);
            }
            catch (Exception e) {
                throw new LayerCreateException(dataService.getName());
            }
        }).collect(Collectors.toMap(layerBean -> layerBean.getId(), layerBean -> layerBean));
        return layerMap;
    }

    private LayerBean createLayer(IDataService dataService, DataSetBean dataSet, Integer beginLevel, Integer endLevel) {
        LayerBean layer = new LayerBean();
        layer.setBeginLevel(beginLevel);
        layer.setEndLevel(endLevel);
        layer.setId(dataService.getName());
        layer.setLayerType(Constants.LAYER_TYPE.VECTOR);
        Constants.GEO_TYPE type = dataService.getGeoType();
        HashMap<Integer, LayerLevelBean> allLayerLevel = new HashMap<Integer, LayerLevelBean>();
        Integer i = layer.getBeginLevel();
        while (i <= layer.getEndLevel()) {
            LayerLevelBean layerLevel = new LayerLevelBean();
            layerLevel.setDataSetId(dataSet.getId());
            layerLevel.setLevel(i);
            allLayerLevel.put(i, layerLevel);
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
        layer.setLevelMap(allLayerLevel);
        if ((type == Constants.GEO_TYPE.LINESTRING || type == Constants.GEO_TYPE.MULTILINESTRING) && ((DataServiceBean)dataService.getBean()).getAdvancedOptions().isHasLineLabel() || (type == Constants.GEO_TYPE.POLYGON || type == Constants.GEO_TYPE.MULTIPOLYGON) && ((DataServiceBean)dataService.getBean()).getAdvancedOptions().isHasPolygonLabel().booleanValue() || type == Constants.GEO_TYPE.MULTIPOINT || type == Constants.GEO_TYPE.POINT) {
            layer.setHaveLabel(true);
            Label label = new Label();
            if (type == Constants.GEO_TYPE.LINESTRING || type == Constants.GEO_TYPE.MULTILINESTRING) {
                label.setType(Constants.LABEL_TYPE.line);
            } else if (type == Constants.GEO_TYPE.MULTIPOINT || type == Constants.GEO_TYPE.POINT) {
                label.setType(Constants.LABEL_TYPE.point);
            } else if (type == Constants.GEO_TYPE.POLYGON || type == Constants.GEO_TYPE.MULTIPOLYGON) {
                label.setType(Constants.LABEL_TYPE.area);
            }
            layer.setLabel(label);
        }
        return layer;
    }

    @Override
    public void setClient(Client client) {
        this.client = client;
    }
}

