/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.service.config.vector_service.dataset;

import com.northpool.resources.datatable.IField;
import com.northpool.service.client.Client;
import com.northpool.service.config.data_service.IDataService;
import com.northpool.service.config.data_source.IDataSourceInService;
import com.northpool.service.config.vector_service.dataset.DataSetBean;
import com.northpool.service.config.vector_service.dataset.IDataSet;
import com.northpool.spatial.Constants;
import java.util.Map;

public class DataSetShell
implements IDataSet {
    protected DataSetBean dataSet;
    protected Client client;
    protected IDataService dataService;

    public DataSetShell(Client client, DataSetBean dataSet) {
        this.client = client;
        this.dataSet = dataSet;
        this.setDataService();
    }

    public void setDataService() {
        if (this.dataService == null) {
            String dataServiceId = this.dataSet.getDataServiceId();
            this.dataService = (IDataService)this.client.getDataServiceManager().get(dataServiceId);
            if (this.dataService == null) {
                throw new RuntimeException(String.format("\u6570\u636e\u670d\u52a1%s\u4e0d\u5b58\u5728", this.dataSet.getDataServiceId()));
            }
        }
    }

    @Override
    public String getFilter() {
        return this.dataSet.getFilter();
    }

    @Override
    public String getSortFiled() {
        return this.dataSet.getSortFiled();
    }

    @Override
    public String getSort() {
        return this.dataSet.getSort();
    }

    @Override
    public String getSpatialFilter() {
        return this.dataSet.getSpatialFilter();
    }

    @Override
    public Map<String, IField> getFieldsMap() {
        if (this.dataService == null) {
            return null;
        }
        return this.dataService.getFieldMap();
    }

    @Override
    public String getIdField() {
        if (this.dataService == null) {
            return null;
        }
        return this.dataService.getIdFieldName();
    }

    @Override
    public String getSpatialField() {
        if (this.dataService == null) {
            return null;
        }
        return this.dataService.getSpatialFieldName();
    }

    @Override
    public Constants.GEO_TYPE getGeometryType() {
        if (this.dataService == null) {
            return null;
        }
        return this.dataService.getGeoType();
    }

    @Override
    public IDataSourceInService getDataSource() {
        if (this.dataService == null) {
            return null;
        }
        return this.dataService.getDataSource();
    }

    @Override
    public String[] getFieldsArr() {
        if (this.dataService == null) {
            return null;
        }
        return this.dataService.getAliasFiledArr();
    }

    @Override
    public IDataService getDataService() {
        return this.dataService;
    }
}

