/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.service.netty.websocket;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.northpool.commons.reflect.Bean;
import com.northpool.service.client.Client;
import com.northpool.service.manager.IClientManager;
import com.northpool.service.manager.cell.ITileDataCellManager;
import com.northpool.service.manager.data_service.IDataServiceManager;
import com.northpool.service.manager.data_service.raster.IRasterDataServiceManager;
import com.northpool.service.manager.data_sources.IDataSourcesManager;
import com.northpool.service.manager.font.IFontManager;
import com.northpool.service.manager.image_service.IImageServiceManager;
import com.northpool.service.manager.style.IStyleManager;
import com.northpool.service.manager.texture.ITextureManager;
import com.northpool.service.manager.vector_service.IVectorServiceManager;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketFrameHandler
extends SimpleChannelInboundHandler<WebSocketFrame> {
    private static final Logger logger = LoggerFactory.getLogger(WebSocketFrameHandler.class);
    private Client client;
    private HashMap<String, Method> methodMap;
    private HashMap<String, IClientManager> managerMap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void channelRead0(ChannelHandlerContext ctx, WebSocketFrame frame) throws Exception {
        byte[] markByte = null;
        try {
            byte[] bytedata;
            if (frame instanceof TextWebSocketFrame) {
                String str = ((TextWebSocketFrame)frame).text();
                JSONArray arr = JSON.parseArray((String)str);
                List params = arr.subList(0, arr.size() - 2);
                String markId = (String)arr.get(arr.size() - 1);
                String methodKey = (String)arr.get(arr.size() - 2);
                String managerName = methodKey.substring(0, methodKey.indexOf("_"));
                IClientManager manager = this.managerMap.get(managerName);
                Method method = this.methodMap.get(methodKey);
                markByte = markId.getBytes("utf-8");
                if (method.getReturnType().getName().equals("void")) {
                    params.add(ctx);
                    params.add(markByte);
                }
                Object result = null;
                if (params.size() == 0) {
                    result = method.invoke((Object)manager, new Object[0]);
                } else {
                    try {
                        result = method.invoke((Object)manager, (Object[])params.stream().toArray(Object[]::new));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        System.out.println("error" + e.getMessage());
                    }
                }
                if (method.getReturnType().getName().equals("void")) {
                    return;
                }
                bytedata = new byte[]{};
                if (result instanceof byte[]) {
                    bytedata = (byte[])result;
                } else if (result instanceof String) {
                    bytedata = ((String)result).getBytes("utf-8");
                } else if (result instanceof Boolean) {
                    bytedata = String.valueOf(result).getBytes("utf-8");
                }
            } else {
                String message = "unsupported frame type: " + frame.getClass().getName();
                throw new UnsupportedOperationException(message);
            }
            ctx.writeAndFlush((Object)new BinaryWebSocketFrame(Unpooled.wrappedBuffer((byte[][])new byte[][]{markByte, {1}, bytedata})));
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            String stackTrace = null;
            try (PrintWriter pw = new PrintWriter(sw);){
                e.printStackTrace(pw);
                stackTrace = sw.toString();
            }
            ctx.writeAndFlush((Object)new BinaryWebSocketFrame(Unpooled.wrappedBuffer((byte[][])new byte[][]{markByte, {0}, stackTrace.getBytes("utf-8")})));
        }
    }

    public void setClient(Client client) {
        this.client = client;
    }

    public void init() {
        try {
            this.methodMap = new HashMap();
            this.managerMap = new HashMap();
            IDataSourcesManager dataSourcesManager = this.client.getDataSourcesManager();
            this.managerMap.put("IDataSourcesManager", dataSourcesManager);
            Method[] methods = Bean.getDeclaredMethods(IDataSourcesManager.class, null);
            for (int i = 0; i < methods.length; ++i) {
                Method method = methods[i];
                this.methodMap.put("IDataSourcesManager_" + method.getName(), method);
            }
            IDataServiceManager dataServiceManager = this.client.getDataServiceManager();
            this.managerMap.put("IDataServiceManager", dataServiceManager);
            methods = Bean.getDeclaredMethods(IDataServiceManager.class, null);
            for (int i = 0; i < methods.length; ++i) {
                Method method = methods[i];
                this.methodMap.put("IDataServiceManager_" + method.getName(), method);
            }
            IRasterDataServiceManager rasterDataServiceManager = this.client.getRasterDataServiceManager();
            this.managerMap.put("IRasterDataServiceManager", rasterDataServiceManager);
            methods = Bean.getDeclaredMethods(IRasterDataServiceManager.class, null);
            for (int i = 0; i < methods.length; ++i) {
                Method method = methods[i];
                this.methodMap.put(StringUtils.join((Object[])new String[]{"IRasterDataServiceManager_", method.getName()}), method);
            }
            IVectorServiceManager vectorServiceManager = this.client.getVectorServiceManager();
            this.managerMap.put("IVectorServiceManager", vectorServiceManager);
            methods = Bean.getDeclaredMethods(IVectorServiceManager.class, null);
            for (int i = 0; i < methods.length; ++i) {
                Method method = methods[i];
                this.methodMap.put("IVectorServiceManager_" + method.getName(), method);
            }
            IImageServiceManager imageServiceManager = this.client.getImageServiceManager();
            this.managerMap.put("IImageServiceManager", imageServiceManager);
            methods = Bean.getDeclaredMethods(IImageServiceManager.class, null);
            for (int i = 0; i < methods.length; ++i) {
                Method method = methods[i];
                this.methodMap.put(StringUtils.join((Object[])new String[]{"IImageServiceManager_", method.getName()}), method);
            }
            IStyleManager styleManager = this.client.getStyleManager();
            this.managerMap.put("IStyleManager", styleManager);
            methods = Bean.getDeclaredMethods(IStyleManager.class, null);
            for (int i = 0; i < methods.length; ++i) {
                Method method = methods[i];
                this.methodMap.put("IStyleManager_" + method.getName(), method);
            }
            ITextureManager textureManager = this.client.getTextureManager();
            this.managerMap.put("ITextureManager", textureManager);
            methods = Bean.getDeclaredMethods(ITextureManager.class, null);
            for (int i = 0; i < methods.length; ++i) {
                Method method = methods[i];
                this.methodMap.put("ITextureManager_" + method.getName(), method);
            }
            IFontManager fontManager = this.client.getFontManager();
            this.managerMap.put("IFontManager", fontManager);
            methods = Bean.getDeclaredMethods(IFontManager.class, null);
            for (int i = 0; i < methods.length; ++i) {
                Method method = methods[i];
                this.methodMap.put("IFontManager_" + method.getName(), method);
            }
            ITileDataCellManager tileDataCellManager = this.client.getTileDataCellManager();
            this.managerMap.put("ITileDataCellManager", tileDataCellManager);
            methods = Bean.getDeclaredMethods(ITileDataCellManager.class, null);
            for (int i = 0; i < methods.length; ++i) {
                Method method = methods[i];
                this.methodMap.put("ITileDataCellManager_" + method.getName(), method);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

