/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.node.config;

import com.northpool.bean.Idable;
import com.northpool.bean.Jsonable;
import com.northpool.devtool.AbnormalCheck.MapserverCheck;
import com.northpool.node.config.NodeBean;
import com.northpool.node.config.NodeShell;
import com.northpool.node.config.NodeType;
import com.northpool.node.statistics.StatisticsLog;
import com.northpool.service.config.IBeanShell;
import com.northpool.service.config.IVersionAble;

public interface INodeService
extends Jsonable,
Idable<String>,
IVersionAble,
IBeanShell<NodeBean> {
    public static INodeService create(String type, String name) {
        NodeType nodeType = NodeType.valueOf(type);
        return INodeService.create(null, nodeType, name);
    }

    public static INodeService create(String url, NodeType type, String name) {
        NodeBean node = new NodeBean();
        node.setType(type);
        node.setUrl(url);
        node.setName(name);
        node.setVersion(String.valueOf(System.currentTimeMillis()));
        if (type.equals((Object)NodeType.Mapserver)) {
            try {
                MapserverCheck.getInst(url).check();
                node.setActive(true);
            }
            catch (Exception e) {
                node.setActive(false);
            }
        }
        return new NodeShell(node);
    }

    public void setStatistics(StatisticsLog var1);

    public String getName();

    public String getId();

    public Boolean isActive();
}

