/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.service.client;

import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoDatabase;
import com.northpool.devtool.AbnormalCheck.CpuCheck;
import com.northpool.devtool.AbnormalCheck.MongoCheck;
import com.northpool.devtool.AbnormalCheck.ZookeeperCheck;
import com.northpool.devtool.model.ZookeeperInfo;
import com.northpool.resources.utils.MongoClientURI;
import com.northpool.service.manager.ManagerFactory;
import com.northpool.service.manager.cell.ITileDataCellManager;
import com.northpool.service.manager.data_service.IDataServiceManager;
import com.northpool.service.manager.data_service.raster.IRasterDataServiceManager;
import com.northpool.service.manager.data_sources.IDataSourcesManager;
import com.northpool.service.manager.exception.ManagerDuplicateException;
import com.northpool.service.manager.exception.ManagerNotFoundException;
import com.northpool.service.manager.font.IFontManager;
import com.northpool.service.manager.image_service.IImageServiceManager;
import com.northpool.service.manager.node.INodeManager;
import com.northpool.service.manager.style.IStyleManager;
import com.northpool.service.manager.task.ITaskManager;
import com.northpool.service.manager.terrain_service.ITerrainServiceManager;
import com.northpool.service.manager.texture.ITextureManager;
import com.northpool.service.manager.vector_service.IVectorServiceManager;
import com.northpool.service.mapserver.MapServerAccess;
import java.io.File;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.RetryNTimes;
import org.apache.ignite.Ignite;
import org.apache.ignite.Ignition;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.ClientConnectorConfiguration;
import org.apache.ignite.configuration.DataPageEvictionMode;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.PageReplacementMode;
import org.apache.ignite.spi.discovery.DiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.ipfinder.TcpDiscoveryIpFinder;
import org.apache.ignite.spi.discovery.tcp.ipfinder.multicast.TcpDiscoveryMulticastIpFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Client {
    private static final int DEFAULT_SESSION_TIMEOUT_MS = Integer.getInteger("curator-default-session-timeout", 60000);
    private static final int DEFAULT_CONNECTION_TIMEOUT_MS = Integer.getInteger("curator-default-connection-timeout", 15000);
    protected String zkAddress;
    protected CuratorFramework zkClient;
    protected Ignite ignite;
    protected MongoDatabase mongoDatabase = null;
    protected MapServerAccess mapServerAccess;
    protected Logger logger = LoggerFactory.getLogger((String)"Client");
    public static String CMD_REQUEST = "/request";
    public static String CMD_RESPONSE = "/response";
    public static final String CMD_CREATE_TIME = "/time";
    public static final String ROOT = "/northpool_service_root";
    protected IDataSourcesManager dataSourcesManager;
    protected IDataServiceManager dataServiceManager;
    protected IVectorServiceManager vectorServiceManager;
    protected ITextureManager textureManager;
    protected IStyleManager styleManager;
    protected IFontManager fontManager;
    protected ITaskManager taskManager;
    protected ITileDataCellManager tileDataCellManager;
    protected INodeManager nodeManager;
    private Integer httpMaxTotal = Runtime.getRuntime().availableProcessors();
    protected IRasterDataServiceManager rasterDataServiceManager;
    protected IImageServiceManager imageServiceManager;
    protected ITerrainServiceManager terrainServiceManager;
    static Client client;

    public Client(String zkAddress) throws Exception {
        this.zkAddress = zkAddress;
        this.zkClient = this.initZkClient(zkAddress);
        this.logger.info("zk\u6b63\u5728\u8fde\u63a5");
        System.setProperty("javax.net.ssl.trustStore", "mongo");
        System.setProperty("javax.net.ssl.trustStorePassword", "changeit");
        System.setProperty("javax.net.ssl.keyStore", "mongoclient");
        System.setProperty("javax.net.ssl.keyStorePassword", "123456");
        this.initManager();
    }

    public static Client getInstance() {
        return client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Client getInstance(String mongoUri, String zkAddress, String mapserverUrl) throws Exception {
        if (client != null) return client;
        Class<Client> clazz = Client.class;
        synchronized (Client.class) {
            if (client != null) return client;
            client = new Client(mongoUri, zkAddress, mapserverUrl);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return client;
        }
    }

    public Client(String mongoUri, String zkAddress, String mapserverUrl) throws Exception {
        String trustStore = System.getenv("trustStore");
        String trustStorePassword = System.getenv("trustStorePassword");
        String keyStore = System.getenv("keyStore");
        String keyStorePassword = System.getenv("keyStorePassword");
        if (trustStore != null && trustStorePassword != null) {
            System.setProperty("javax.net.ssl.trustStore", trustStore);
            System.setProperty("javax.net.ssl.trustStorePassword", trustStorePassword);
        }
        if (keyStore != null && keyStorePassword != null) {
            System.setProperty("javax.net.ssl.keyStore", keyStore);
            System.setProperty("javax.net.ssl.keyStorePassword", keyStorePassword);
        }
        CpuCheck.getInst().check();
        this.mongoDatabase = this.initMongoClient(mongoUri);
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{zkAddress})) {
            this.zkAddress = zkAddress;
            this.zkClient = this.initZkClient(zkAddress);
        }
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{mapserverUrl})) {
            MapServerAccess.setUrlPrifix(mapserverUrl);
        }
        this.initManager();
        client = this;
    }

    public Client(String igniteAddress, Integer igniteClientPort, String igniteMcastGrp, String mapserverUrl) throws Exception {
        this.initIgniteByMultiCastMode(igniteAddress, igniteClientPort, igniteMcastGrp);
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{mapserverUrl})) {
            MapServerAccess.setUrlPrifix(mapserverUrl);
        }
        this.initManager();
    }

    private void initIgniteByMultiCastMode(String igniteAddress, Integer igniteClientPort, String igniteMcastGrp) {
        IgniteConfiguration cfg = new IgniteConfiguration();
        String property = System.getProperty("user.dir");
        cfg.setWorkDirectory(property + File.separator + "ignitedb");
        cfg.setClientMode(false);
        cfg.setPeerClassLoadingEnabled(true);
        DataStorageConfiguration storageCfg = new DataStorageConfiguration();
        DataRegionConfiguration defaultDataRegionConfiguration = storageCfg.getDefaultDataRegionConfiguration();
        defaultDataRegionConfiguration.setPersistenceEnabled(true);
        defaultDataRegionConfiguration.setMaxSize(0x3200000L);
        defaultDataRegionConfiguration.setPageReplacementMode(PageReplacementMode.SEGMENTED_LRU);
        defaultDataRegionConfiguration.setPageEvictionMode(DataPageEvictionMode.RANDOM_LRU);
        cfg.setDataStorageConfiguration(storageCfg);
        TcpDiscoveryMulticastIpFinder ipFinder = new TcpDiscoveryMulticastIpFinder();
        if (StringUtils.isNotEmpty((CharSequence)igniteAddress)) {
            ipFinder.setAddresses(Collections.singletonList(igniteAddress));
        }
        if (StringUtils.isNotEmpty((CharSequence)igniteMcastGrp)) {
            ipFinder.setMulticastGroup(igniteMcastGrp);
        }
        cfg.setDiscoverySpi((DiscoverySpi)new TcpDiscoverySpi().setIpFinder((TcpDiscoveryIpFinder)ipFinder));
        if (igniteClientPort != null) {
            ClientConnectorConfiguration clientConnectorCfg = new ClientConnectorConfiguration();
            clientConnectorCfg.setPort(igniteClientPort.intValue());
            clientConnectorCfg.setPortRange(0);
            cfg.setClientConnectorConfiguration(clientConnectorCfg);
        }
        this.ignite = Ignition.start((IgniteConfiguration)cfg);
        this.ignite.cluster().state(ClusterState.ACTIVE);
        this.ignite.cluster().setBaselineTopology(this.ignite.cluster().forServers().nodes());
        this.ignite.resetLostPartitions(this.ignite.cacheNames());
    }

    public void initManager() throws Exception {
        try {
            ManagerFactory.setLoader(Thread.currentThread().getContextClassLoader());
            this.dataSourcesManager = ManagerFactory.getManager(IDataSourcesManager.class, this);
            this.dataServiceManager = ManagerFactory.getManager(IDataServiceManager.class, this);
            this.vectorServiceManager = ManagerFactory.getManager(IVectorServiceManager.class, this);
            this.textureManager = ManagerFactory.getManager(ITextureManager.class, this);
            this.styleManager = ManagerFactory.getManager(IStyleManager.class, this);
            this.fontManager = ManagerFactory.getManager(IFontManager.class, this);
            this.tileDataCellManager = ManagerFactory.getManager(ITileDataCellManager.class, this);
            this.nodeManager = ManagerFactory.getManager(INodeManager.class, this);
        }
        catch (ManagerDuplicateException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (ManagerNotFoundException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private synchronized CuratorFramework initZkClient(String zkAddress) {
        ZookeeperCheck.getInst(zkAddress).check();
        CuratorFrameworkFactory.Builder builder = CuratorFrameworkFactory.builder();
        ZookeeperInfo zkInfo = new ZookeeperInfo(zkAddress);
        if (zkInfo.hasAuth().booleanValue()) {
            builder.authorization("digest", (zkInfo.getUser() + ":" + zkInfo.getPassword()).getBytes());
        }
        CuratorFramework client = builder.connectString(zkInfo.getAddress()).retryPolicy((RetryPolicy)new RetryNTimes(10, 5000)).sessionTimeoutMs(DEFAULT_SESSION_TIMEOUT_MS).connectionTimeoutMs(DEFAULT_CONNECTION_TIMEOUT_MS).build();
        client.start();
        return client;
    }

    public MongoDatabase initMongoClient(String uri) {
        MongoClient mongoClient;
        MongoCheck.getInst(uri).check();
        MongoClientURI mongoClientURI = new MongoClientURI(uri);
        try {
            mongoClient = MongoClients.create((String)uri);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        return mongoClient.getDatabase(mongoClientURI.getDatabase());
    }

    public CuratorFramework getZoo() {
        return this.zkClient;
    }

    public IVectorServiceManager getVectorServiceManager() {
        return this.vectorServiceManager;
    }

    public IDataSourcesManager getDataSourcesManager() {
        return this.dataSourcesManager;
    }

    public IDataServiceManager getDataServiceManager() {
        return this.dataServiceManager;
    }

    public IRasterDataServiceManager getRasterDataServiceManager() {
        return this.rasterDataServiceManager;
    }

    public IImageServiceManager getImageServiceManager() {
        return this.imageServiceManager;
    }

    public ITerrainServiceManager getTerrainServiceManager() {
        return this.terrainServiceManager;
    }

    public ITextureManager getTextureManager() {
        return this.textureManager;
    }

    public IStyleManager getStyleManager() {
        return this.styleManager;
    }

    public IFontManager getFontManager() {
        return this.fontManager;
    }

    public ITaskManager getTaskManager() {
        return this.taskManager;
    }

    public ITileDataCellManager getTileDataCellManager() {
        return this.tileDataCellManager;
    }

    public INodeManager getNodeManager() {
        return this.nodeManager;
    }

    public String getZkAddress() {
        return this.zkAddress;
    }

    public void setZkAddress(String zkAddress) {
        this.zkAddress = zkAddress;
    }

    public MongoDatabase initMongoClient() {
        return this.mongoDatabase;
    }

    public void setMongoDatabase(MongoDatabase mongoDatabase) {
        this.mongoDatabase = mongoDatabase;
    }

    public MapServerAccess getMapServerAccess() {
        return new MapServerAccess(this.httpMaxTotal, 180000);
    }

    public void setMapServerAccess(MapServerAccess mapServerAccess) {
        this.mapServerAccess = mapServerAccess;
    }

    public Ignite getIgnite() {
        return this.ignite;
    }
}

