/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.service.config.raster_service;

import com.alibaba.fastjson.JSON;
import com.northpool.service.client.Client;
import com.northpool.service.config.CanStartStop;
import com.northpool.service.config.Constants;
import com.northpool.service.config.data_service.raster.IRasterDataService;
import com.northpool.service.config.data_source.IDataSourceInService;
import com.northpool.service.config.raster_service.IRasterService;
import com.northpool.service.config.raster_service.RasterServiceBean;
import com.northpool.service.config.raster_service.dataset.RasterDataSetBean;
import com.northpool.service.config.raster_service.layer.IRasterLayer;
import com.northpool.service.config.raster_service.layer.RasterLayerBean;
import com.northpool.service.config.raster_service.layer.RasterLayerShell;
import com.northpool.service.config.vector_service.CacheInfoBean;
import com.northpool.service.config.vector_service.CacheInfoShell;
import com.northpool.service.config.vector_service.ICacheable;
import com.northpool.service.config.vector_service.storage.IStorageInfo;
import com.northpool.spatial.grid.GridManager;
import com.northpool.spatial.grid.IGridSystem;
import com.northpool.spatial.grid.QuadtreeGrid;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.bson.Document;

public class RasterServiceShell
implements IRasterService {
    protected Client client;
    protected RasterServiceBean rasterService;
    protected LinkedHashMap<String, IRasterLayer> layerMap;
    protected ICacheable cacheInfo;
    protected IStorageInfo storageInfo;

    public RasterServiceShell(Client client, RasterServiceBean rasterService) {
        this.client = client;
        this.rasterService = rasterService;
        this.layerMap = this.createLayerMap(client, rasterService.getDataSetMap(), rasterService.getLayerMap());
        this.cacheInfo = this.createCacheInfo(rasterService.getCacheInfo());
    }

    private LinkedHashMap<String, IRasterLayer> createLayerMap(Client client, Map<String, RasterDataSetBean> dataSetMap, LinkedHashMap<String, RasterLayerBean> layerBeanMap) {
        Set<Map.Entry<String, RasterLayerBean>> entries = layerBeanMap.entrySet();
        LinkedHashMap<String, IRasterLayer> layerMap = new LinkedHashMap<String, IRasterLayer>(layerBeanMap.size());
        for (Map.Entry<String, RasterLayerBean> entry : entries) {
            RasterLayerShell layerShell = new RasterLayerShell(client, entry.getValue(), dataSetMap);
            layerMap.put(layerShell.getId(), layerShell);
        }
        return layerMap;
    }

    private ICacheable createCacheInfo(CacheInfoBean cacheInfo) {
        if (cacheInfo == null) {
            return null;
        }
        CacheInfoShell cacheShell = new CacheInfoShell(this.client, cacheInfo);
        return cacheShell;
    }

    @Override
    public Constants.SERVICE_TYPE getServiceType() {
        return this.rasterService.getServiceType();
    }

    public String toJson() {
        return JSON.toJSON((Object)this.rasterService).toString();
    }

    public String mark() {
        return this.rasterService.getId();
    }

    @Override
    public Document toDocument() {
        return Document.parse((String)this.toJson());
    }

    @Override
    public void start() {
        this.rasterService.setState(CanStartStop.STATE_TYPE.run);
    }

    @Override
    public void stop() {
        this.rasterService.setState(CanStartStop.STATE_TYPE.stop);
    }

    @Override
    public String state() {
        return this.rasterService.getState().name();
    }

    @Override
    public CanStartStop.STATE_TYPE getState() {
        return this.rasterService.getState();
    }

    @Override
    public void rollback(CanStartStop.STATE_TYPE state) {
        this.rasterService.setState(state);
    }

    @Override
    public boolean needDataCache() {
        return false;
    }

    @Override
    public boolean needImgCache() {
        if (this.cacheInfo == null) {
            return false;
        }
        return this.cacheInfo.needImgCache();
    }

    @Override
    public String getDataScript() {
        return null;
    }

    @Override
    public String getImgScript() {
        if (this.cacheInfo == null) {
            return null;
        }
        return this.cacheInfo.getImgScript();
    }

    @Override
    public IDataSourceInService getDataCacheSource() {
        return null;
    }

    @Override
    public IDataSourceInService getImgCacheSource() {
        if (this.cacheInfo == null) {
            return null;
        }
        return this.cacheInfo.getImgCacheSource();
    }

    @Override
    public CacheInfoBean getCacheInfoBean() {
        return this.cacheInfo.getCacheInfoBean();
    }

    @Override
    public void drop(String serverName, String styleId) throws Exception {
    }

    @Override
    public void setVersion(String version) {
        this.rasterService.setVersion(version);
    }

    @Override
    public String getId() {
        return this.rasterService.getId();
    }

    @Override
    public String getName() {
        return this.rasterService.getName();
    }

    @Override
    public String getVersion() {
        return this.rasterService.getVersion();
    }

    @Override
    public IGridSystem getGridTree() {
        String gridName = this.rasterService.getGridTreeName();
        QuadtreeGrid quadtreeGrid = GridManager.getQuadtreeGrid((String)gridName, (int[])this.rasterService.getOrigin(), (double[])this.rasterService.getResolutions());
        if (quadtreeGrid == null) {
            throw new RuntimeException(StringUtils.join((Object[])new String[]{"\u6ca1\u6709\u627e\u5230\u683c\u7f51\u4e3a ", gridName}));
        }
        return quadtreeGrid;
    }

    @Override
    public String getBbox() {
        return this.rasterService.getBbox();
    }

    @Override
    public Integer getBeginLevel() {
        return this.rasterService.getBeginLevel();
    }

    @Override
    public Integer getEndLevel() {
        return this.rasterService.getEndLevel();
    }

    @Override
    public LinkedHashMap<String, IRasterLayer> getLayerMap() {
        return this.layerMap;
    }

    @Override
    public Boolean isSinglelayer() {
        return this.layerMap.entrySet().size() == 1;
    }

    @Override
    public Boolean allowCache() {
        if (this.cacheInfo == null) {
            return false;
        }
        return true;
    }

    @Override
    public RasterServiceBean getBean() {
        return this.rasterService;
    }

    @Override
    public Client getClient() {
        return this.client;
    }

    @Override
    public void refresh() {
        List<IRasterDataService> rasterDataServices = this.getLayerMap().values().stream().flatMap(layer -> layer.getLevelMap().values().stream()).map(layerlevel -> layerlevel.getDataSet().getRasterDataService()).collect(Collectors.toList());
        rasterDataServices.forEach(dataService -> dataService.refresh());
    }

    @Override
    public void addCacheInfo(ICacheable cacheInfo) {
        this.cacheInfo = cacheInfo;
        this.getBean().setCacheInfo(cacheInfo.getCacheInfoBean());
    }

    @Override
    public ICacheable getCacheInfo() {
        return this.cacheInfo;
    }

    @Override
    public IStorageInfo getStorageInfo() {
        return this.storageInfo;
    }

    @Override
    public int[] getOrigin() {
        return this.rasterService.getOrigin();
    }

    @Override
    public double[] getResolutions() {
        return this.rasterService.getResolutions();
    }

    @Override
    public List<String> getDataServiceIds() {
        return this.getBean().getDataSetMap().values().stream().map(dataSetBean -> dataSetBean.getDataServiceId()).collect(Collectors.toList());
    }
}

